/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendEntryIterator;
import org.apache.hugegraph.backend.store.mysql.MysqlBackendEntry;
import org.apache.hugegraph.backend.store.mysql.MysqlTable;
import org.apache.hugegraph.backend.store.mysql.ResultSetWrapper;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.StringEncoding;

public class MysqlEntryIterator
extends BackendEntryIterator {
    private final ResultSetWrapper results;
    private final BiFunction<BackendEntry, BackendEntry, BackendEntry> merger;
    private BackendEntry next;
    private BackendEntry lastest;
    private boolean exceedLimit;

    public MysqlEntryIterator(ResultSetWrapper rs, Query query, BiFunction<BackendEntry, BackendEntry, BackendEntry> merger) {
        super(query);
        this.results = rs;
        this.merger = merger;
        this.next = null;
        this.lastest = null;
        this.exceedLimit = false;
    }

    /*
     * Unable to fully structure code
     */
    protected final boolean fetch() {
        if (!MysqlEntryIterator.$assertionsDisabled && this.current != null) {
            throw new AssertionError();
        }
        if (this.next != null) {
            this.current = this.next;
            this.next = null;
        }
        try {
            while (this.results.next()) {
                block10: {
                    entry = this.row2Entry(this.results.resultSet());
                    this.lastest = entry;
                    merged = this.merger.apply(this.current, (BackendEntry)entry);
                    if (this.current != null) break block10;
                    this.current = merged;
                    ** GOTO lbl22
                }
                if (merged != this.current) {
                    if (!MysqlEntryIterator.$assertionsDisabled && this.next != null) {
                        throw new AssertionError();
                    }
                    this.next = merged;
                } else {
                    if (!MysqlEntryIterator.$assertionsDisabled && merged == null) {
                        throw new AssertionError();
                    }
lbl22:
                    // 3 sources

                    if (!this.reachLimit(this.fetched() - 1L)) continue;
                    this.exceedLimit = true;
                    this.removeLastRecord();
                    this.results.close();
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new BackendException("Fetch next error", (Throwable)e);
        }
        return this.current != null;
    }

    protected PageState pageState() {
        byte[] position;
        if (this.lastest == null || !this.exceedLimit && this.fetched() <= this.query.limit() && this.next == null) {
            position = PageState.EMPTY_BYTES;
        } else {
            MysqlBackendEntry entry = (MysqlBackendEntry)this.lastest;
            position = new PagePosition(entry.columnsMap()).toBytes();
        }
        return new PageState(position, 0, (int)this.count());
    }

    protected void skipOffset() {
    }

    protected final long sizeOf(BackendEntry entry) {
        MysqlBackendEntry e = (MysqlBackendEntry)entry;
        int subRowsSize = e.subRows().size();
        return subRowsSize > 0 ? (long)subRowsSize : 1L;
    }

    protected final long skip(BackendEntry entry, long skip) {
        MysqlBackendEntry e = (MysqlBackendEntry)entry;
        E.checkState(((long)e.subRows().size() > skip ? 1 : 0) != 0, (String)"Invalid entry to skip", (Object[])new Object[0]);
        for (long i = 0L; i < skip; ++i) {
            e.subRows().remove(0);
        }
        return e.subRows().size();
    }

    public void close() throws Exception {
        this.results.close();
    }

    private MysqlBackendEntry row2Entry(ResultSet result) throws SQLException {
        HugeType type = this.query.resultType();
        MysqlBackendEntry entry = new MysqlBackendEntry(type);
        ResultSetMetaData metaData = result.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String name = metaData.getColumnLabel(i);
            HugeKeys key = MysqlTable.parseKey(name);
            Object value = result.getObject(i);
            if (value == null) {
                assert (key == HugeKeys.EXPIRED_TIME);
                continue;
            }
            entry.column(key, value);
        }
        return entry;
    }

    private void removeLastRecord() {
        MysqlBackendEntry entry = (MysqlBackendEntry)this.current;
        int lastOne = entry.subRows().size() - 1;
        assert (lastOne >= 0);
        entry.subRows().remove(lastOne);
    }

    public static class PagePosition {
        private final Map<HugeKeys, Object> columns;

        public PagePosition(Map<HugeKeys, Object> columns) {
            this.columns = columns;
        }

        public Map<HugeKeys, Object> columns() {
            return this.columns;
        }

        public String toString() {
            return JsonUtil.toJson(this.columns);
        }

        public byte[] toBytes() {
            String json = JsonUtil.toJson(this.columns);
            return StringEncoding.encode((String)json);
        }

        public static PagePosition fromBytes(byte[] bytes) {
            String json = StringEncoding.decode((byte[])bytes);
            Map columns = (Map)JsonUtil.fromJson((String)json, Map.class);
            LinkedHashMap<HugeKeys, Object> keyColumns = new LinkedHashMap<HugeKeys, Object>();
            for (Map.Entry entry : columns.entrySet()) {
                HugeKeys key = MysqlTable.parseKey((String)entry.getKey());
                keyColumns.put(key, entry.getValue());
            }
            return new PagePosition(keyColumns);
        }
    }
}

