/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class MysqlOptions
extends OptionHolder {
    private static volatile MysqlOptions instance;
    public static final ConfigOption<String> JDBC_DRIVER;
    public static final ConfigOption<String> JDBC_URL;
    public static final ConfigOption<String> JDBC_USERNAME;
    public static final ConfigOption<String> JDBC_PASSWORD;
    public static final ConfigOption<Boolean> JDBC_FORCED_AUTO_RECONNECT;
    public static final ConfigOption<Integer> JDBC_RECONNECT_MAX_TIMES;
    public static final ConfigOption<Integer> JDBC_RECONNECT_INTERVAL;
    public static final ConfigOption<String> JDBC_SSL_MODE;
    public static final ConfigOption<String> JDBC_STORAGE_ENGINE;

    protected MysqlOptions() {
    }

    public static synchronized MysqlOptions instance() {
        if (instance == null) {
            instance = new MysqlOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        JDBC_DRIVER = new ConfigOption("jdbc.driver", "The JDBC driver class to connect database.", OptionChecker.disallowEmpty(), (Object)"com.mysql.jdbc.Driver");
        JDBC_URL = new ConfigOption("jdbc.url", "The url of database in JDBC format.", OptionChecker.disallowEmpty(), (Object)"jdbc:mysql://127.0.0.1:3306");
        JDBC_USERNAME = new ConfigOption("jdbc.username", "The username to login database.", OptionChecker.disallowEmpty(), (Object)"root");
        JDBC_PASSWORD = new ConfigOption("jdbc.password", "The password corresponding to jdbc.username.", null, (Object)"******");
        JDBC_FORCED_AUTO_RECONNECT = new ConfigOption("jdbc.forced_auto_reconnect", "Whether to forced auto reconnect to the database even if the connection fails at the first time. Note that forced_auto_reconnect=true will disable fail-fast.", OptionChecker.disallowEmpty(), (Object)false);
        JDBC_RECONNECT_MAX_TIMES = new ConfigOption("jdbc.reconnect_max_times", "The reconnect times when the database connection fails.", OptionChecker.rangeInt((Number)1, (Number)10), (Object)3);
        JDBC_RECONNECT_INTERVAL = new ConfigOption("jdbc.reconnect_interval", "The interval(seconds) between reconnections when the database connection fails.", OptionChecker.rangeInt((Number)1, (Number)10), (Object)3);
        JDBC_SSL_MODE = new ConfigOption("jdbc.ssl_mode", "The SSL mode of connections with database.", OptionChecker.disallowEmpty(), (Object)"false");
        JDBC_STORAGE_ENGINE = new ConfigOption("jdbc.storage_engine", "The storage engine of backend store database, like InnoDB/MyISAM/RocksDB for MySQL.", OptionChecker.disallowEmpty(), (Object)"InnoDB");
    }
}

