/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.postgresql;

import com.google.common.collect.ImmutableMap;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.TableDefine;
import org.apache.hugegraph.backend.store.mysql.MysqlBackendEntry;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.MysqlTables;
import org.apache.hugegraph.backend.store.postgresql.PostgresqlTable;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;

public class PostgresqlTables {
    private static final Map<String, String> TYPES_MAPPING = ImmutableMap.builder().put((Object)"BOOLEAN", (Object)"BOOL").put((Object)"TINYINT", (Object)"INT").put((Object)"INT", (Object)"INT").put((Object)"DOUBLE", (Object)"DECIMAL").put((Object)"SMALL_TEXT", (Object)"VARCHAR(255)").put((Object)"MID_TEXT", (Object)"VARCHAR(1024)").put((Object)"LARGE_TEXT", (Object)"VARCHAR(65533)").put((Object)"HUGE_TEXT", (Object)"TEXT").build();

    public static class ShardIndex
    extends PostgresqlTableTemplate {
        public ShardIndex(String store) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.ShardIndex(store, TYPES_MAPPING));
        }

        protected final String entryId(MysqlBackendEntry entry) {
            return ((MysqlTables.ShardIndex)this.template).entryId(entry);
        }
    }

    public static class RangeDoubleIndex
    extends PostgresqlTableTemplate {
        public static final String TABLE = HugeType.RANGE_DOUBLE_INDEX.string();

        public RangeDoubleIndex(String store) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.RangeDoubleIndex(store, TABLE, TYPES_MAPPING));
        }

        protected final String entryId(MysqlBackendEntry entry) {
            return ((MysqlTables.RangeDoubleIndex)this.template).entryId(entry);
        }
    }

    public static class RangeLongIndex
    extends PostgresqlTableTemplate {
        public static final String TABLE = HugeType.RANGE_LONG_INDEX.string();

        public RangeLongIndex(String store) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.RangeLongIndex(store, TABLE, TYPES_MAPPING));
        }

        protected final String entryId(MysqlBackendEntry entry) {
            return ((MysqlTables.RangeLongIndex)this.template).entryId(entry);
        }
    }

    public static class RangeFloatIndex
    extends PostgresqlTableTemplate {
        public static final String TABLE = HugeType.RANGE_FLOAT_INDEX.string();

        public RangeFloatIndex(String store) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.RangeFloatIndex(store, TABLE, TYPES_MAPPING));
        }

        protected final String entryId(MysqlBackendEntry entry) {
            return ((MysqlTables.RangeFloatIndex)this.template).entryId(entry);
        }
    }

    public static class RangeIntIndex
    extends PostgresqlTableTemplate {
        public static final String TABLE = HugeType.RANGE_INT_INDEX.string();

        public RangeIntIndex(String store) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.RangeIntIndex(store, TABLE, TYPES_MAPPING));
        }

        protected final String entryId(MysqlBackendEntry entry) {
            return ((MysqlTables.RangeIntIndex)this.template).entryId(entry);
        }
    }

    public static class UniqueIndex
    extends SecondaryIndex {
        public static final String TABLE = MysqlTables.UniqueIndex.TABLE;

        public UniqueIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class SearchIndex
    extends SecondaryIndex {
        public static final String TABLE = MysqlTables.SearchIndex.TABLE;

        public SearchIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class SecondaryIndex
    extends PostgresqlTableTemplate {
        public static final String TABLE = MysqlTables.SecondaryIndex.TABLE;

        public SecondaryIndex(String store) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.SecondaryIndex(store, TABLE, TYPES_MAPPING));
        }

        public SecondaryIndex(String store, String table) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.SecondaryIndex(store, table, TYPES_MAPPING));
        }

        protected final String entryId(MysqlBackendEntry entry) {
            return ((MysqlTables.SecondaryIndex)this.template).entryId(entry);
        }
    }

    public static class Edge
    extends PostgresqlTableTemplate {
        public Edge(String store, Directions direction) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.Edge(store, direction, TYPES_MAPPING));
        }

        protected List<Object> idColumnValue(Id id) {
            MysqlTables.Edge table = (MysqlTables.Edge)this.template;
            return table.idColumnValue(id);
        }

        public void delete(MysqlSessions.Session session, TableBackendEntry.Row entry) {
            MysqlTables.Edge table = (MysqlTables.Edge)this.template;
            table.delete(session, entry);
        }

        protected BackendEntry mergeEntries(BackendEntry e1, BackendEntry e2) {
            MysqlTables.Edge table = (MysqlTables.Edge)this.template;
            return table.mergeEntries(e1, e2);
        }
    }

    public static class Vertex
    extends PostgresqlTableTemplate {
        public static final String TABLE = HugeType.VERTEX.string();

        public Vertex(String store) {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.Vertex(store, TYPES_MAPPING));
        }
    }

    public static class IndexLabel
    extends PostgresqlTableTemplate {
        public IndexLabel() {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.IndexLabel(TYPES_MAPPING));
        }
    }

    public static class PropertyKey
    extends PostgresqlTableTemplate {
        public PropertyKey() {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.PropertyKey(TYPES_MAPPING));
        }
    }

    public static class EdgeLabel
    extends PostgresqlTableTemplate {
        public EdgeLabel() {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.EdgeLabel(TYPES_MAPPING));
        }
    }

    public static class VertexLabel
    extends PostgresqlTableTemplate {
        public VertexLabel() {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.VertexLabel(TYPES_MAPPING));
        }
    }

    public static class Counters
    extends PostgresqlTableTemplate {
        public Counters() {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.Counters(TYPES_MAPPING));
        }

        public long getCounter(MysqlSessions.Session session, HugeType type) {
            MysqlTables.Counters table = (MysqlTables.Counters)this.template;
            return table.getCounter(session, type);
        }

        public void increaseCounter(MysqlSessions.Session session, HugeType type, long increment) {
            String update = String.format("INSERT INTO %s (%s, %s) VALUES ('%s', %s) ON CONFLICT (%s) DO UPDATE SET ID = %s.ID + %s;", this.table(), Counters.formatKey((HugeKeys)HugeKeys.SCHEMA_TYPE), Counters.formatKey((HugeKeys)HugeKeys.ID), type.name(), increment, Counters.formatKey((HugeKeys)HugeKeys.SCHEMA_TYPE), this.table(), increment);
            try {
                session.execute(update);
            }
            catch (SQLException e) {
                throw new BackendException("Failed to update counters with type '%s'", (Throwable)e, new Object[]{type});
            }
        }
    }

    public static class Meta
    extends PostgresqlTableTemplate {
        public Meta() {
            super((MysqlTables.MysqlTableTemplate)new MysqlTables.Meta(TYPES_MAPPING));
        }

        public void writeVersion(MysqlSessions.Session session, String version) {
            String versionColumn = Meta.formatKey((HugeKeys)HugeKeys.VERSION);
            String insert = String.format("INSERT INTO %s VALUES ('%s', '%s') ON CONFLICT(name) DO NOTHING;", this.table(), versionColumn, version);
            try {
                session.execute(insert);
            }
            catch (SQLException e) {
                throw new BackendException("Failed to insert driver version with '%s'", (Throwable)e, new Object[]{insert});
            }
        }

        public String readVersion(MysqlSessions.Session session) {
            MysqlTables.Meta table = (MysqlTables.Meta)this.template;
            return table.readVersion(session);
        }
    }

    public static class PostgresqlTableTemplate
    extends PostgresqlTable {
        protected MysqlTables.MysqlTableTemplate template;

        public PostgresqlTableTemplate(MysqlTables.MysqlTableTemplate template) {
            super(template.table());
            this.template = template;
        }

        public TableDefine tableDefine() {
            return this.template.tableDefine();
        }
    }
}

