/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common;

import com.alipay.sofa.rpc.base.Sortable;
import com.alipay.sofa.rpc.common.json.JSON;
import com.alipay.sofa.rpc.common.struct.OrderedComparator;
import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.CompatibleTypeUtils;
import com.alipay.sofa.rpc.common.utils.FileUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.LogCodes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RpcConfigs {
    private static final ConcurrentMap<String, Object> CFG = new ConcurrentHashMap<String, Object>();
    private static final ConcurrentMap<String, List<RpcConfigListener>> CFG_LISTENER = new ConcurrentHashMap<String, List<RpcConfigListener>>();

    private static void init() {
        try {
            String json = FileUtils.file2String(RpcConfigs.class, "rpc-config-default.json", "UTF-8");
            Map map = JSON.parseObject(json, Map.class);
            CFG.putAll(map);
            RpcConfigs.loadCustom("sofa-rpc/rpc-config.json");
            RpcConfigs.loadCustom("META-INF/sofa-rpc/rpc-config.json");
            CFG.putAll(new HashMap<Object, Object>(System.getProperties()));
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990021"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCustom(String fileName) throws IOException {
        Enumeration<URL> urls;
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(RpcConfigs.class);
        Enumeration<URL> enumeration = urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
        if (urls != null) {
            ArrayList<CfgFile> allFile = new ArrayList<CfgFile>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStreamReader input = null;
                BufferedReader reader = null;
                try {
                    String line;
                    input = new InputStreamReader(url.openStream(), "utf-8");
                    reader = new BufferedReader(input);
                    StringBuilder context = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        context.append(line).append("\n");
                    }
                    Map map = JSON.parseObject(context.toString(), Map.class);
                    Integer order = (Integer)map.get("rpc.config.order");
                    allFile.add(new CfgFile(url, order == null ? 0 : order, map));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (input == null) continue;
                    input.close();
                }
            }
            Collections.sort(allFile, new OrderedComparator());
            for (CfgFile file : allFile) {
                CFG.putAll(file.getMap());
            }
        }
    }

    public static void putValue(String key, Object newValue) {
        Object oldValue = CFG.get(key);
        if (RpcConfigs.changed(oldValue, newValue)) {
            CFG.put(key, newValue);
            List rpcConfigListeners = (List)CFG_LISTENER.get(key);
            if (CommonUtils.isNotEmpty(rpcConfigListeners)) {
                for (RpcConfigListener rpcConfigListener : rpcConfigListeners) {
                    rpcConfigListener.onChange(oldValue, newValue);
                }
            }
        }
    }

    static synchronized void removeValue(String key) {
        Object oldValue = CFG.get(key);
        if (oldValue != null) {
            CFG.remove(key);
            List rpcConfigListeners = (List)CFG_LISTENER.get(key);
            if (CommonUtils.isNotEmpty(rpcConfigListeners)) {
                for (RpcConfigListener rpcConfigListener : rpcConfigListeners) {
                    rpcConfigListener.onChange(oldValue, null);
                }
            }
        }
    }

    public static boolean getBooleanValue(String primaryKey) {
        Object val = CFG.get(primaryKey);
        if (val == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990022", primaryKey));
        }
        return Boolean.valueOf(val.toString());
    }

    public static boolean getBooleanValue(String primaryKey, String secondaryKey) {
        Object val = CFG.get(primaryKey);
        if (val == null && (val = CFG.get(secondaryKey)) == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990022", primaryKey + "/" + secondaryKey));
        }
        return Boolean.valueOf(val.toString());
    }

    public static int getIntValue(String primaryKey) {
        Object val = CFG.get(primaryKey);
        if (val == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990022", primaryKey));
        }
        return Integer.parseInt(val.toString());
    }

    public static int getIntValue(String primaryKey, String secondaryKey) {
        Object val = CFG.get(primaryKey);
        if (val == null && (val = CFG.get(secondaryKey)) == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990022", primaryKey + "/" + secondaryKey));
        }
        return Integer.parseInt(val.toString());
    }

    public static <T extends Enum<T>> T getEnumValue(String primaryKey, Class<T> enumClazz) {
        String val = (String)CFG.get(primaryKey);
        if (val == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990022", primaryKey));
        }
        return Enum.valueOf(enumClazz, val);
    }

    public static String getStringValue(String primaryKey) {
        String val = (String)CFG.get(primaryKey);
        if (val == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990022", primaryKey));
        }
        return val;
    }

    public static String getStringValue(String primaryKey, String secondaryKey) {
        String val = (String)CFG.get(primaryKey);
        if (val == null) {
            val = (String)CFG.get(secondaryKey);
            if (val == null) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("019990022", primaryKey + "/" + secondaryKey));
            }
            return val;
        }
        return val;
    }

    public static List getListValue(String primaryKey) {
        List val = (List)CFG.get(primaryKey);
        if (val == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("019990022", primaryKey));
        }
        return val;
    }

    public static <T> T getOrDefaultValue(String primaryKey, T defaultValue) {
        Object val = CFG.get(primaryKey);
        if (val == null) {
            return defaultValue;
        }
        Class<?> type = defaultValue == null ? null : defaultValue.getClass();
        return (T)CompatibleTypeUtils.convert(val, type);
    }

    public static synchronized void subscribe(String key, RpcConfigListener listener) {
        ArrayList<RpcConfigListener> listeners = (ArrayList<RpcConfigListener>)CFG_LISTENER.get(key);
        if (listeners == null) {
            listeners = new ArrayList<RpcConfigListener>();
            CFG_LISTENER.put(key, listeners);
        }
        listeners.add(listener);
    }

    public static synchronized void unSubscribe(String key, RpcConfigListener listener) {
        List listeners = (List)CFG_LISTENER.get(key);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.size() == 0) {
                CFG_LISTENER.remove(key);
            }
        }
    }

    protected static boolean changed(Object oldObj, Object newObj) {
        return oldObj == null ? newObj != null : !oldObj.equals(newObj);
    }

    static {
        RpcConfigs.init();
    }

    public static interface RpcConfigListener<T> {
        public void onChange(T var1, T var2);
    }

    private static class CfgFile
    implements Sortable {
        private final URL url;
        private final int order;
        private final Map map;

        public CfgFile(URL url, int order, Map map) {
            this.url = url;
            this.order = order;
            this.map = map;
        }

        public URL getUrl() {
            return this.url;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        public Map getMap() {
            return this.map;
        }
    }
}

