/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.config.AbstractIdConfig;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RegistryConfig
extends AbstractIdConfig
implements Serializable {
    private static final long serialVersionUID = -2921019924557602234L;
    private String protocol = RpcConfigs.getStringValue("default.registry");
    private String address;
    private String index = RpcConfigs.getStringValue("registry.index.address");
    private boolean register = RpcConfigs.getBooleanValue("service.register");
    private boolean subscribe = RpcConfigs.getBooleanValue("service.subscribe");
    private int timeout = RpcConfigs.getIntValue("registry.invoke.timeout");
    private int connectTimeout = RpcConfigs.getIntValue("registry.connect.timeout");
    private String file;
    private boolean batch = RpcConfigs.getBooleanValue("registry.batch");
    private int batchSize = RpcConfigs.getIntValue("registry.batch.size");
    protected int heartbeatPeriod = RpcConfigs.getIntValue("registry.heartbeat.period");
    protected int reconnectPeriod = RpcConfigs.getIntValue("registry.reconnect.period");
    protected Map<String, String> parameters;

    public String getProtocol() {
        return this.protocol;
    }

    public RegistryConfig setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public RegistryConfig setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public RegistryConfig setIndex(String index) {
        this.index = index;
        return this;
    }

    public boolean isRegister() {
        return this.register;
    }

    public RegistryConfig setRegister(boolean register) {
        this.register = register;
        return this;
    }

    public boolean isSubscribe() {
        return this.subscribe;
    }

    public RegistryConfig setSubscribe(boolean subscribe) {
        this.subscribe = subscribe;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public RegistryConfig setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public RegistryConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public RegistryConfig setFile(String file) {
        this.file = file;
        return this;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public RegistryConfig setBatch(boolean batch) {
        this.batch = batch;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public RegistryConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public RegistryConfig setHeartbeatPeriod(int heartbeatPeriod) {
        this.heartbeatPeriod = heartbeatPeriod;
        return this;
    }

    public int getReconnectPeriod() {
        return this.reconnectPeriod;
    }

    public RegistryConfig setReconnectPeriod(int reconnectPeriod) {
        this.reconnectPeriod = reconnectPeriod;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public RegistryConfig setParameters(Map<String, String> parameters) {
        if (this.parameters == null) {
            this.parameters = new ConcurrentHashMap<String, String>();
            this.parameters.putAll(parameters);
        }
        return this;
    }

    public RegistryConfig setParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new ConcurrentHashMap<String, String>();
        }
        this.parameters.put(key, value);
        return this;
    }

    public String getParameter(String key) {
        return this.parameters == null ? null : this.parameters.get(key);
    }

    public String toString() {
        return "RegistryConfig{protocol='" + this.protocol + '\'' + ", address='" + this.address + '\'' + ", index='" + this.index + '\'' + ", register=" + this.register + ", subscribe=" + this.subscribe + ", timeout=" + this.timeout + ", connectTimeout=" + this.connectTimeout + ", file='" + this.file + '\'' + ", batch=" + this.batch + ", batchSize=" + this.batchSize + ", heartbeatPeriod=" + this.heartbeatPeriod + ", reconnectPeriod=" + this.reconnectPeriod + ", parameters=" + this.parameters + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegistryConfig)) {
            return false;
        }
        RegistryConfig that = (RegistryConfig)o;
        if (this.register != that.register) {
            return false;
        }
        if (this.subscribe != that.subscribe) {
            return false;
        }
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.batch != that.batch) {
            return false;
        }
        if (this.batchSize != that.batchSize) {
            return false;
        }
        if (this.heartbeatPeriod != that.heartbeatPeriod) {
            return false;
        }
        if (this.reconnectPeriod != that.reconnectPeriod) {
            return false;
        }
        if (!this.protocol.equals(that.protocol)) {
            return false;
        }
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.index != null ? !this.index.equals(that.index) : that.index != null) {
            return false;
        }
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
    }

    public int hashCode() {
        int result = this.protocol.hashCode();
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + (this.register ? 1 : 0);
        result = 31 * result + (this.subscribe ? 1 : 0);
        result = 31 * result + this.timeout;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + (this.batch ? 1 : 0);
        result = 31 * result + this.batchSize;
        result = 31 * result + this.heartbeatPeriod;
        result = 31 * result + this.reconnectPeriod;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }
}

