/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import java.util.ArrayList;
import java.util.List;

public abstract class BeanIdMatchFilter
extends Filter {
    private static final String ID_SPLIT = ",";
    private static final String ID_EXCLUDE = "!";
    private String idRule;
    private boolean allEffective = true;
    private List<String> effectiveId;
    private List<String> excludeId;
    private volatile boolean formatComplete;
    private final Object formatLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        AbstractInterfaceConfig config = invoker.config;
        String invokerId = config.getId();
        if (!this.formatComplete) {
            Object object = this.formatLock;
            synchronized (object) {
                if (!this.formatComplete) {
                    this.formatId(this.idRule);
                    this.formatComplete = true;
                }
            }
        }
        return this.isMatch(invokerId);
    }

    protected void formatId(String ruleId) {
        if (StringUtils.isBlank(ruleId)) {
            return;
        }
        String[] ids = ruleId.split(ID_SPLIT);
        ArrayList<String> effectiveId = new ArrayList<String>(ids.length);
        ArrayList<String> excludeId = new ArrayList<String>(ids.length);
        for (String id : ids) {
            if (id.startsWith(ID_EXCLUDE)) {
                excludeId.add(id.substring(1));
                continue;
            }
            effectiveId.add(id);
        }
        this.effectiveId = effectiveId;
        this.excludeId = excludeId;
        this.allEffective = false;
    }

    protected boolean isMatch(String invokerId) {
        if (this.allEffective) {
            return true;
        }
        if (this.excludeId.size() == 0) {
            return this.effectiveId.contains(invokerId);
        }
        return !this.excludeId.contains(invokerId);
    }

    public String getIdRule() {
        return this.idRule;
    }

    public void setIdRule(String idRule) {
        this.idRule = idRule;
    }
}

