/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.hystrix;

import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.hystrix.SetterFactory;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultSetterFactory
implements SetterFactory {
    private static final Map<Method, HystrixCommand.Setter> SETTER_CACHE = new ConcurrentHashMap<Method, HystrixCommand.Setter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HystrixCommand.Setter createSetter(FilterInvoker invoker, SofaRequest request) {
        Method clientMethod = request.getMethod();
        if (SETTER_CACHE.containsKey(clientMethod)) return SETTER_CACHE.get(clientMethod);
        Class<DefaultSetterFactory> clazz = DefaultSetterFactory.class;
        synchronized (DefaultSetterFactory.class) {
            if (SETTER_CACHE.containsKey(clientMethod)) return SETTER_CACHE.get(clientMethod);
            String interfaceId = invoker.getConfig().getInterfaceId();
            String commandKey = DefaultSetterFactory.generateCommandKey(interfaceId, request.getMethod());
            HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)interfaceId)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey));
            SETTER_CACHE.put(clientMethod, setter);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return SETTER_CACHE.get(clientMethod);
        }
    }

    public static String generateCommandKey(String interfaceId, Method method) {
        StringBuilder builder = new StringBuilder(interfaceId).append("#").append(method.getName()).append("(");
        if (method.getParameterTypes().length > 0) {
            for (Class<?> parameterType : method.getParameterTypes()) {
                builder.append(parameterType.getSimpleName()).append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.append(")").toString();
    }
}

