/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.message.bolt;

import com.alipay.remoting.InvokeCallback;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;

public abstract class AbstractInvokeCallback
implements InvokeCallback {
    protected final ConsumerConfig consumerConfig;
    protected final ProviderInfo providerInfo;
    protected final SofaRequest request;
    protected ClassLoader classLoader;
    protected RpcInternalContext context;

    protected AbstractInvokeCallback(ConsumerConfig consumerConfig, ProviderInfo providerInfo, SofaRequest request, RpcInternalContext context, ClassLoader classLoader) {
        this.consumerConfig = consumerConfig;
        this.providerInfo = providerInfo;
        this.request = request;
        this.context = context;
        this.classLoader = classLoader;
    }

    protected void recordClientElapseTime() {
        Long startTime;
        if (this.context != null && (startTime = (Long)this.context.removeAttachment("_client_send_time")) != null) {
            this.context.setAttachment("_client_elapse", RpcRuntimeContext.now() - startTime);
        }
    }

    protected void pickupBaggage(SofaResponse response) {
        if (RpcInvokeContext.isBaggageEnable()) {
            RpcInvokeContext invokeCtx = null;
            if (this.context != null) {
                invokeCtx = (RpcInvokeContext)this.context.getAttachment(".invoke_ctx");
            }
            if (invokeCtx == null) {
                invokeCtx = RpcInvokeContext.getContext();
            } else {
                RpcInvokeContext.setContext(invokeCtx);
            }
            BaggageResolver.pickupFromResponse(invokeCtx, response);
        }
    }
}

