/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.CommandEncoder;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.RpcCommand;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import org.slf4j.Logger;

public class RpcCommandEncoder
implements CommandEncoder {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");

    @Override
    public void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        try {
            if (msg instanceof RpcCommand) {
                RpcCommand cmd = (RpcCommand)msg;
                out.writeByte(1);
                out.writeByte((int)cmd.getType());
                out.writeShort((int)((RpcCommand)msg).getCmdCode().value());
                out.writeByte((int)cmd.getVersion());
                out.writeInt(cmd.getId());
                out.writeByte((int)cmd.getSerializer());
                if (cmd instanceof RequestCommand) {
                    out.writeInt(((RequestCommand)cmd).getTimeout());
                }
                if (cmd instanceof ResponseCommand) {
                    ResponseCommand response = (ResponseCommand)cmd;
                    out.writeShort((int)response.getResponseStatus().getValue());
                }
                out.writeShort((int)cmd.getClazzLength());
                out.writeShort((int)cmd.getHeaderLength());
                out.writeInt(cmd.getContentLength());
                if (cmd.getClazzLength() > 0) {
                    out.writeBytes(cmd.getClazz());
                }
                if (cmd.getHeaderLength() > 0) {
                    out.writeBytes(cmd.getHeader());
                }
                if (cmd.getContentLength() > 0) {
                    out.writeBytes(cmd.getContent());
                }
            } else {
                String warnMsg = "msg type [" + msg.getClass() + "] is not subclass of RpcCommand";
                logger.warn(warnMsg);
            }
        }
        catch (Exception e) {
            logger.error("Exception caught!", (Throwable)e);
            throw e;
        }
    }
}

