/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rpc;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.RpcOptions;
import org.apache.hugegraph.rpc.RpcConsumerConfig;
import org.apache.hugegraph.util.E;

public class RpcClientProvider {
    private final RpcConsumerConfig consumerConfig;

    public RpcClientProvider(HugeConfig config) {
        String rpcUrl = (String)config.get(RpcOptions.RPC_REMOTE_URL);
        String selfUrl = (String)config.get(RpcOptions.RPC_SERVER_HOST) + ":" + config.get(RpcOptions.RPC_SERVER_PORT);
        rpcUrl = RpcClientProvider.excludeSelfUrl(rpcUrl, selfUrl);
        this.consumerConfig = StringUtils.isNotBlank((CharSequence)rpcUrl) ? new RpcConsumerConfig(config, rpcUrl) : null;
    }

    public boolean enabled() {
        return this.consumerConfig != null;
    }

    public RpcConsumerConfig config() {
        E.checkArgument((this.consumerConfig != null ? 1 : 0) != 0, (String)"RpcClient is not enabled, please config option '%s' and ensure to add an address other than self service", (Object[])new Object[]{RpcOptions.RPC_REMOTE_URL.name()});
        return this.consumerConfig;
    }

    public void unreferAll() {
        if (this.consumerConfig != null) {
            this.consumerConfig.removeAllServiceProxy();
        }
    }

    public void destroy() {
        if (this.consumerConfig != null) {
            this.consumerConfig.destroy();
        }
    }

    protected static String excludeSelfUrl(String rpcUrl, String selfUrl) {
        String[] urls = StringUtils.splitWithCommaOrSemicolon((String)rpcUrl);
        LinkedHashSet<String> urlSet = new LinkedHashSet<String>(Arrays.asList(urls));
        urlSet.remove(selfUrl);
        return String.join((CharSequence)",", urlSet);
    }
}

