/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { CommonI18n } from "../CommonI18n";
import { names } from "../names";

export const de: CommonI18n = {
  names,
  terms: {
    apply: "Anwenden",
    available: "Verfügbar",
    back: "Zurück",
    cancel: "Abbrechen",
    change: "Ändern",
    close: "Schließen",
    copy: "Kopieren",
    configure: "Konfigurieren",
    confirm: "Bestätigen",
    connected: "Verbunden",
    continue: "Fortfahren",
    cut: "Ausschneiden",
    deploy: "Bereitstellen",
    disconnected: "Getrennt",
    dismiss: "Ablehnen",
    done: "Fertig",
    download: "Download",
    edit: "Bearbeiten",
    edited: "Editiert",
    evaluation: "Auswertung",
    exit: "Beenden",
    file: "Datei",
    files: "Dateien",
    forum: "Forum",
    fullScreen: "Vollbild",
    host: "Host",
    install: "Installieren",
    inputs: "Eingänge",
    launch: "Starten",
    loading: "Laden",
    macosApplicationFolder: "Programm",
    namespace: "Namespace (project)",
    new: "Neu",
    next: "Nächste",
    note: "Anmerkung",
    open: "Öffnen",
    oops: "Oops",
    os: {
      initials: "OS",
      full: "Betriebssystem",
    },
    outputs: "Ausgänge",
    paste: "Einfügen",
    poweredBy: "Powered by",
    quit: "Beenden",
    readonly: "Schreibgeschützt",
    redo: "Wiederholen",
    reset: "Zurücksetzen",
    run: "Ausführen",
    save: "Speichern",
    selection: "Auswahl",
    setup: "Einrichtung",
    start: "Start",
    token: "Token",
    undo: "Rückgängig",
    uninstall: "Deinstallieren",
    username: "Username",
    validation: "Validierung",
  },
};
