/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetHeaders;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.james.server.core.MimeMessageUtil;

public class MailHeaders
extends InternetHeaders
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 238748126601L;
    private boolean modified = false;
    private long size = -1L;

    public MailHeaders() {
    }

    public MailHeaders(InputStream in) throws MessagingException {
        this.load(in);
    }

    public void writeTo(OutputStream out) throws MessagingException {
        MimeMessageUtil.writeHeadersTo(this.getAllHeaderLines(), out);
    }

    public byte[] toByteArray() throws MessagingException {
        UnsynchronizedByteArrayOutputStream headersBytes = new UnsynchronizedByteArrayOutputStream();
        this.writeTo((OutputStream)headersBytes);
        return headersBytes.toByteArray();
    }

    public boolean isSet(String name) {
        String[] value = super.getHeader(name);
        return value != null && value.length != 0;
    }

    public synchronized void addHeader(String arg0, String arg1) {
        if ("Return-Path".equalsIgnoreCase(arg0)) {
            this.headers.add(0, new InternetHeaders.InternetHeader(arg0, arg1));
        } else {
            super.addHeader(arg0, arg1);
        }
        this.modified();
    }

    public synchronized void setHeader(String arg0, String arg1) {
        if ("Return-Path".equalsIgnoreCase(arg0)) {
            super.removeHeader(arg0);
        }
        super.setHeader(arg0, arg1);
        this.modified();
    }

    public synchronized void removeHeader(String name) {
        super.removeHeader(name);
        this.modified();
    }

    public synchronized void addHeaderLine(String line) {
        super.addHeaderLine(line);
        this.modified();
    }

    private void modified() {
        this.modified = true;
        this.size = -1L;
    }

    public boolean isValid() {
        return this.isSet("Date") && this.isSet("To") && this.isSet("From");
    }

    public synchronized long getSize() {
        if (this.size == -1L || this.modified) {
            long c = 0L;
            Enumeration headerLines = this.getAllHeaderLines();
            while (headerLines.hasMoreElements()) {
                c += (long)((String)headerLines.nextElement()).length();
                c += 2L;
            }
            this.size = c;
            this.modified = false;
        }
        return this.size;
    }
}

