/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.google.common.base.CharMatcher;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.MailboxName;
import org.apache.james.imap.message.request.SetACLRequest;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;

public class SetACLCommandParser
extends AbstractImapCommandParser {
    @Inject
    public SetACLCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.SETACL_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        MailboxName mailboxName = new MailboxName(request.mailbox());
        MailboxACL.EntryKey entryKey = MailboxACL.EntryKey.deserialize((String)request.astring());
        String editModeAndRights = request.astring();
        request.eol();
        MailboxACL.ACLCommand aclCommand = MailboxACL.command().key(entryKey).mode(this.parseEditMode(editModeAndRights)).rights(this.parseRights(editModeAndRights)).build();
        return new SetACLRequest(tag, mailboxName, aclCommand);
    }

    private MailboxACL.EditMode parseEditMode(String editModeAndRights) {
        if (StringUtils.isEmpty((CharSequence)editModeAndRights)) {
            return MailboxACL.EditMode.REPLACE;
        }
        return switch (editModeAndRights.charAt(0)) {
            case '+' -> MailboxACL.EditMode.ADD;
            case '-' -> MailboxACL.EditMode.REMOVE;
            default -> MailboxACL.EditMode.REPLACE;
        };
    }

    private MailboxACL.Rfc4314Rights parseRights(String editModeAndRights) throws DecodingException {
        if (StringUtils.isEmpty((CharSequence)editModeAndRights)) {
            throw new DecodingException(HumanReadableText.INVALID_COMMAND, "SETACL command must include rights. If you want to remove rights for that user, please use a DELETEACL command.");
        }
        try {
            if (CharMatcher.anyOf((CharSequence)"+-").matches(editModeAndRights.charAt(0))) {
                return MailboxACL.Rfc4314Rights.deserialize((String)editModeAndRights.substring(1));
            }
            return MailboxACL.Rfc4314Rights.deserialize((String)editModeAndRights);
        }
        catch (UnsupportedRightException e) {
            throw new DecodingException(HumanReadableText.UNSUPPORTED, e.getMessage(), e.getCause());
        }
    }
}

