/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.PlainBlobId;
import org.apache.james.blob.cassandra.CassandraBlobStoreDAO;
import org.apache.james.blob.cassandra.CassandraBucketDAO;
import org.apache.james.blob.cassandra.CassandraDefaultBucketDAO;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.server.blob.deduplication.BlobStoreFactory;

public class CassandraBlobStoreFactory {
    public static BlobStoreFactory.RequireStoringStrategy forTesting(CqlSession session, MetricFactory metricFactory) {
        PlainBlobId.Factory blobIdFactory = new PlainBlobId.Factory();
        CassandraBucketDAO bucketDAO = new CassandraBucketDAO((BlobId.Factory)blobIdFactory, session);
        CassandraDefaultBucketDAO defaultBucketDAO = new CassandraDefaultBucketDAO(session, (BlobId.Factory)blobIdFactory);
        CassandraBlobStoreDAO blobStoreDAO = new CassandraBlobStoreDAO(defaultBucketDAO, bucketDAO, CassandraConfiguration.DEFAULT_CONFIGURATION, BucketName.DEFAULT, metricFactory);
        return BlobStoreFactory.builder().blobStoreDAO((BlobStoreDAO)blobStoreDAO).blobIdFactory((BlobId.Factory)blobIdFactory).defaultBucketName();
    }
}

