/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.BackendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Field {
    private final FieldType type;
    private final String value;

    public Field(FieldType type, String value) {
        this.type = Assert.requireNonNull(type, "type must not be null");
        this.value = Assert.requireNonNull(value, "value must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return this.type == field.type && Objects.equals(this.value, field.value);
    }

    public FieldType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public String toString() {
        return "Field{type=" + (Object)((Object)this.type) + ", value='" + this.value + '\'' + '}';
    }

    static List<Field> decode(ByteBuf in) {
        byte discriminator;
        Assert.requireNonNull(in, "in must not be null");
        ArrayList<Field> fields = new ArrayList<Field>();
        while (in.readableBytes() > 0 && (discriminator = in.readByte()) != 0) {
            fields.add(new Field(FieldType.valueOf(discriminator), BackendMessageUtils.readCStringUTF8(in)));
        }
        return fields;
    }

    public static enum FieldType {
        CODE('C'),
        COLUMN_NAME('c'),
        CONSTRAINT_NAME('n'),
        DATA_TYPE_NAME('d'),
        DETAIL('D'),
        FILE('F'),
        HINT('H'),
        INTERNAL_POSITION('p'),
        INTERNAL_QUERY('q'),
        LINE('L'),
        MESSAGE('M'),
        POSITION('P'),
        ROUTINE('R'),
        SCHEMA_NAME('s'),
        SEVERITY_LOCALIZED('S'),
        SEVERITY_NON_LOCALIZED('V'),
        TABLE_NAME('t'),
        UNKNOWN('\u0000'),
        WHERE('W');

        private final char discriminator;

        private FieldType(char discriminator) {
            this.discriminator = discriminator;
        }

        static FieldType valueOf(byte b) {
            for (FieldType fieldType : FieldType.values()) {
                if (b != fieldType.discriminator) continue;
                return fieldType;
            }
            return UNKNOWN;
        }
    }
}

