/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.metrics;

import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;

public enum DseSessionMetric implements SessionMetric
{
    CONTINUOUS_CQL_REQUESTS("continuous-cql-requests"),
    GRAPH_REQUESTS("graph-requests"),
    GRAPH_CLIENT_TIMEOUTS("graph-client-timeouts");

    private static final Map<String, DseSessionMetric> BY_PATH;
    private final String path;

    private DseSessionMetric(String path) {
        this.path = path;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public static DseSessionMetric fromPath(@NonNull String path) {
        DseSessionMetric metric = BY_PATH.get(path);
        if (metric == null) {
            throw new IllegalArgumentException("Unknown DSE session metric path " + path);
        }
        return metric;
    }

    private static Map<String, DseSessionMetric> sortByPath() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (DseSessionMetric value : DseSessionMetric.values()) {
            result.put((Object)value.getPath(), (Object)value);
        }
        return result.build();
    }

    static {
        BY_PATH = DseSessionMetric.sortByPath();
    }
}

