/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.imageMap.ImageMapNotSupportedException;
import org.jCharts.properties.DataAxisProperties;

abstract class StackedAreaChart {
    StackedAreaChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        if (axisChart.getImageMap() != null) {
            throw new ImageMapNotSupportedException("HTML client-side image maps are not supported on Area Charts.");
        }
        float f = axisChart.getXAxis().getTickStart();
        GeneralPath[] generalPathArray = new GeneralPath[iAxisChartDataSet.getNumberOfDataSets()];
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
        float f2 = 0.0f;
        int n = 0;
        while (n < generalPathArray.length) {
            generalPathArray[n] = new GeneralPath();
            generalPathArray[n].moveTo(f, axisChart.getYAxis().getZeroLineCoordinate());
            f2 = (float)((double)f2 + iAxisChartDataSet.getValue(n, 0));
            generalPathArray[n].lineTo(f, axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), f2, axisChart.getYAxis().getScaleCalculator().getMinValue()));
            ++n;
        }
        int n2 = 1;
        while (n2 < iAxisChartDataSet.getNumberOfDataItems()) {
            f += axisChart.getXAxis().getScalePixelWidth();
            f2 = 0.0f;
            int n3 = 0;
            while (n3 < generalPathArray.length) {
                f2 = (float)((double)f2 + iAxisChartDataSet.getValue(n3, n2));
                generalPathArray[n3].lineTo(f, axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), f2, axisChart.getYAxis().getScaleCalculator().getMinValue()));
                ++n3;
            }
            ++n2;
        }
        Area[] areaArray = new Area[generalPathArray.length];
        Area area = null;
        int n4 = 0;
        while (n4 < generalPathArray.length) {
            generalPathArray[n4].lineTo(f, axisChart.getYAxis().getZeroLineCoordinate());
            generalPathArray[n4].closePath();
            Area area2 = new Area(generalPathArray[n4]);
            if (n4 > 0) {
                areaArray[n4] = (Area)area2.clone();
                areaArray[n4].subtract(area);
                area = area2;
            } else {
                areaArray[0] = area2;
                area = areaArray[0];
            }
            ++n4;
        }
        Graphics2D graphics2D = axisChart.getGraphics2D();
        int n5 = 0;
        while (n5 < areaArray.length) {
            graphics2D.setPaint(iAxisChartDataSet.getPaint(n5));
            graphics2D.fill(areaArray[n5]);
            ++n5;
        }
    }
}

