/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.geometry;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.Segment;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.interval.IntSpan;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\tJ\u0011\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\tH\u0086\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tJ\u0013\u0010$\u001a\u00020\u00172\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010&\u001a\u00020\u0003H\u0016J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0000J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0000J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000202R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\u00a8\u00064"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/Rectangle;", "", "x", "", "y", "width", "height", "(IIII)V", "origin", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "dimension", "(Lorg/jetbrains/letsPlot/commons/geometry/Vector;Lorg/jetbrains/letsPlot/commons/geometry/Vector;)V", "boundPoints", "", "getBoundPoints", "()[Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "boundSegments", "Lorg/jetbrains/letsPlot/commons/geometry/Segment;", "getBoundSegments", "()[Lorg/jetbrains/letsPlot/commons/geometry/Segment;", "getDimension", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "isEmpty", "", "()Z", "getOrigin", "add", "v", "center", "changeDimension", "dim", "contains", "r", "distance", "", "to", "equals", "other", "hashCode", "innerIntersects", "rect", "intersect", "intersects", "sub", "toDoubleRectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "toString", "", "union", "xRange", "Lorg/jetbrains/letsPlot/commons/interval/IntSpan;", "yRange", "commons"})
public final class Rectangle {
    @NotNull
    private final Vector origin;
    @NotNull
    private final Vector dimension;

    public Rectangle(@NotNull Vector origin, @NotNull Vector dimension) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.origin = origin;
        this.dimension = dimension;
    }

    @NotNull
    public final Vector getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Vector getDimension() {
        return this.dimension;
    }

    public final boolean isEmpty() {
        return this.dimension.getX() <= 0 || this.dimension.getY() <= 0;
    }

    @NotNull
    public final Segment[] getBoundSegments() {
        Vector[] p = this.getBoundPoints();
        Segment[] segmentArray = new Segment[]{new Segment(p[0], p[1]), new Segment(p[1], p[2]), new Segment(p[2], p[3]), new Segment(p[3], p[0])};
        return segmentArray;
    }

    private final Vector[] getBoundPoints() {
        Vector[] vectorArray = new Vector[]{this.origin, this.origin.add(new Vector(this.dimension.getX(), 0)), this.origin.add(this.dimension), this.origin.add(new Vector(0, this.dimension.getY()))};
        return vectorArray;
    }

    public Rectangle(int x2, int y2, int width, int height) {
        this(new Vector(x2, y2), new Vector(width, height));
    }

    @NotNull
    public final Rectangle add(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Rectangle(this.origin.add(v), this.dimension);
    }

    @NotNull
    public final Rectangle sub(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Rectangle(this.origin.sub(v), this.dimension);
    }

    public final boolean contains(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.origin) && this.contains(r.origin.add(r.dimension));
    }

    public final boolean contains(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.origin.getX() <= v.getX() && this.origin.getX() + this.dimension.getX() >= v.getX() && this.origin.getY() <= v.getY() && this.origin.getY() + this.dimension.getY() >= v.getY();
    }

    @NotNull
    public final Rectangle union(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Vector newOrigin = this.origin.min(rect.origin);
        Vector corner = this.origin.add(this.dimension);
        Vector rectCorner = rect.origin.add(rect.dimension);
        Vector newCorner = corner.max(rectCorner);
        Vector newDimension = newCorner.sub(newOrigin);
        return new Rectangle(newOrigin, newDimension);
    }

    public final boolean intersects(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Vector t1 = this.origin;
        Vector t2 = this.origin.add(this.dimension);
        Vector r1 = rect.origin;
        Vector r2 = rect.origin.add(rect.dimension);
        return r2.getX() >= t1.getX() && t2.getX() >= r1.getX() && r2.getY() >= t1.getY() && t2.getY() >= r1.getY();
    }

    @NotNull
    public final Rectangle intersect(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (!this.intersects(r)) {
            throw new IllegalStateException("rectangle [" + this + "] doesn't intersect [" + r + ']');
        }
        Vector too = this.origin.add(this.dimension);
        Vector roo = r.origin.add(r.dimension);
        Vector ioo = too.min(roo);
        Vector io = this.origin.max(r.origin);
        return new Rectangle(io, ioo.sub(io));
    }

    public final boolean innerIntersects(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Vector t1 = this.origin;
        Vector t2 = this.origin.add(this.dimension);
        Vector r1 = rect.origin;
        Vector r2 = rect.origin.add(rect.dimension);
        return r2.getX() > t1.getX() && t2.getX() > r1.getX() && r2.getY() > t1.getY() && t2.getY() > r1.getY();
    }

    @NotNull
    public final Rectangle changeDimension(@NotNull Vector dim) {
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        return new Rectangle(this.origin, dim);
    }

    public final double distance(@NotNull Vector to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.toDoubleRectangle().distance(to.toDoubleVector());
    }

    @NotNull
    public final IntSpan xRange() {
        return new IntSpan(this.origin.getX(), this.origin.getX() + this.dimension.getX());
    }

    @NotNull
    public final IntSpan yRange() {
        return new IntSpan(this.origin.getY(), this.origin.getY() + this.dimension.getY());
    }

    public int hashCode() {
        return this.origin.hashCode() * 31 + this.dimension.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Rectangle)) {
            return false;
        }
        Rectangle otherRect = (Rectangle)other;
        return Intrinsics.areEqual((Object)this.origin, (Object)otherRect.origin) && Intrinsics.areEqual((Object)this.dimension, (Object)otherRect.dimension);
    }

    private final DoubleRectangle toDoubleRectangle() {
        return new DoubleRectangle(this.origin.toDoubleVector(), this.dimension.toDoubleVector());
    }

    @NotNull
    public final Vector center() {
        return this.origin.add(new Vector(this.dimension.getX() / 2, this.dimension.getY() / 2));
    }

    @NotNull
    public String toString() {
        return this.origin + " - " + this.dimension;
    }
}

