/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalFunction;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProvider;
import org.exparity.hamcrest.date.core.types.Interval;
import org.hamcrest.Description;

public class IsWithin<T, E>
extends TemporalMatcher<T> {
    private final Interval expectedInterval;
    private final TemporalProvider<E> reference;
    private final TemporalConverter<T, E> converter;
    private final TemporalFunction<E> functions;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsWithin(Interval interval, TemporalConverter<T, E> converter, TemporalProvider<E> reference, TemporalFunction<E> functions, Optional<ZoneId> zone, Locale locale) {
        this.expectedInterval = interval;
        this.converter = converter;
        this.reference = reference;
        this.functions = functions;
        this.locale = locale;
        this.zone = zone;
    }

    public IsWithin(Interval interval, TemporalConverter<T, E> converter, TemporalProvider<E> reference, TemporalFunction<E> functions) {
        this(interval, converter, reference, functions, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        E actualValue;
        E referenceValue = this.reference.apply(this.zone);
        Interval actualInterval = this.functions.interval(referenceValue, actualValue = this.converter.apply(actual, this.zone), this.expectedInterval.getUnit());
        if (actualInterval.longerThan(this.expectedInterval)) {
            mismatchDescription.appendText("the date is " + this.functions.describe(actualValue, this.locale) + " and " + actualInterval.describe(this.locale) + " different");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is within " + this.expectedInterval.describe(this.locale) + " of " + this.functions.describe(this.reference.apply(this.zone), this.locale));
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsWithin<T, E>(this.expectedInterval, this.converter, this.reference, this.functions, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsWithin<T, E>(this.expectedInterval, this.converter, this.reference, this.functions, this.zone, locale);
    }
}

