/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.oro.util.Cache;
import org.apache.oro.util.CacheLRU;

public class EncoderCache {
    public static final String URL_ARGUMENT_ENCODING = StandardCharsets.UTF_8.name();
    private final Cache cache;

    public EncoderCache(int cacheSize) {
        this.cache = new CacheLRU(cacheSize);
    }

    public String getEncoded(String k) {
        try {
            return this.getEncoded(k, URL_ARGUMENT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Should not happen: " + e.toString());
        }
    }

    public String getEncoded(String k, String contentEncoding) throws UnsupportedEncodingException {
        String cacheKey = k + contentEncoding;
        Object encodedValue = this.cache.getElement((Object)cacheKey);
        if (encodedValue != null) {
            return (String)encodedValue;
        }
        encodedValue = URLEncoder.encode(k, contentEncoding);
        this.cache.addElement((Object)cacheKey, encodedValue);
        return (String)encodedValue;
    }
}

