/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.FunTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0010\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0017\u0010\u0016\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/LogTransform;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/FunTransform;", "base", "", "(D)V", "lowerLimDomain", "getLowerLimDomain", "()D", "lowerLimDomain$delegate", "Lkotlin/Lazy;", "lowerLimTransformed", "getLowerLimTransformed", "lowerLimTransformed$delegate", "apply", "v", "(Ljava/lang/Double;)Ljava/lang/Double;", "createApplicableDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "middle", "(Ljava/lang/Double;)Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "hasDomainLimits", "", "isInDomain", "(Ljava/lang/Double;)Z", "isZero", "toApplicableDomain", "range", "Companion", "plot-base"})
public class LogTransform
extends FunTransform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double base;
    @NotNull
    private final Lazy lowerLimTransformed$delegate;
    @NotNull
    private final Lazy lowerLimDomain$delegate;

    public LogTransform(final double base) {
        super((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(){

            @NotNull
            public final Double invoke(double v) {
                return MathKt.log((double)v, (double)base);
            }
        }), (Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(){

            @NotNull
            public final Double invoke(double v) {
                return Math.pow(base, v);
            }
        }));
        this.base = base;
        this.lowerLimTransformed$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ LogTransform this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return LogTransform.Companion.calcLowerLimTransformed$plot_base(LogTransform.access$getBase$p(this.this$0));
            }
        }));
        this.lowerLimDomain$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ LogTransform this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return LogTransform.Companion.calcLowerLimDomain$plot_base(LogTransform.access$getBase$p(this.this$0));
            }
        }));
    }

    private final double getLowerLimTransformed() {
        Lazy lazy = this.lowerLimTransformed$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    private final double getLowerLimDomain() {
        Lazy lazy = this.lowerLimDomain$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @Override
    public boolean hasDomainLimits() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInDomain(@Nullable Double v) {
        if (!SeriesUtil.INSTANCE.isFinite(v)) return false;
        Double d = v;
        Intrinsics.checkNotNull((Object)d);
        if (!(d >= this.getLowerLimDomain())) return false;
        return true;
    }

    @Override
    @Nullable
    public Double apply(@Nullable Double v) {
        Double d;
        Double transformedValue = super.apply(v);
        if (transformedValue == null) {
            d = null;
        } else if (Double.isNaN(transformedValue)) {
            d = Double.NaN;
        } else {
            double d2 = transformedValue;
            d = Math.max(this.getLowerLimTransformed(), d2);
        }
        return d;
    }

    @Override
    @NotNull
    public DoubleSpan createApplicableDomain(@Nullable Double middle) {
        double d;
        if (this.isInDomain(middle)) {
            Double d2 = middle;
            Intrinsics.checkNotNull((Object)d2);
            d = Math.max(d2, this.getLowerLimDomain());
        } else {
            d = this.isZero(middle) ? this.getLowerLimDomain() : 1.0;
        }
        double middle2 = d;
        double lower2 = middle2 < 1.0 ? middle2 / (double)2 : middle2 - 0.5;
        return new DoubleSpan(Math.max(lower2, this.getLowerLimDomain()), middle2 + 0.5);
    }

    @Override
    @NotNull
    public DoubleSpan toApplicableDomain(@NotNull DoubleSpan range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        double lower2 = Math.max(range.getLowerEnd(), this.getLowerLimDomain());
        double upper2 = Math.max(range.getUpperEnd(), lower2);
        return new DoubleSpan(lower2, upper2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isZero(Double v) {
        if (!SeriesUtil.INSTANCE.isFinite(v)) return false;
        Double d = v;
        Intrinsics.checkNotNull((Object)d);
        if (!(d >= 0.0)) return false;
        if (!(v < this.getLowerLimDomain())) return false;
        return true;
    }

    public static final /* synthetic */ double access$getBase$p(LogTransform $this) {
        return $this.base;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0006J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/LogTransform$Companion;", "", "()V", "calcLowerLimDomain", "", "base", "calcLowerLimDomain$plot_base", "calcLowerLimTransformed", "calcLowerLimTransformed$plot_base", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public final double calcLowerLimTransformed$plot_base(double base) {
            return -1.7976931348623157E308 / base;
        }

        public final double calcLowerLimDomain$plot_base(double base) {
            return Double.MIN_VALUE * base;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

