/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.colorspace;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.colorspace.HCL;
import org.jetbrains.letsPlot.commons.colorspace.LAB;
import org.jetbrains.letsPlot.commons.colorspace.LABKt;
import org.jetbrains.letsPlot.commons.colorspace.LUV;
import org.jetbrains.letsPlot.commons.colorspace.LUVKt;
import org.jetbrains.letsPlot.commons.colorspace.XYZ;
import org.jetbrains.letsPlot.commons.colorspace.XYZKt;
import org.jetbrains.letsPlot.commons.values.Color;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001\u001a\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"hclFromLuv", "Lorg/jetbrains/letsPlot/commons/colorspace/HCL;", "luv", "Lorg/jetbrains/letsPlot/commons/colorspace/LUV;", "hclFromRgb", "rgb", "Lorg/jetbrains/letsPlot/commons/values/Color;", "labFromRgb", "Lorg/jetbrains/letsPlot/commons/colorspace/LAB;", "luvFromHcl", "hcl", "rgbFromHcl", "alpha", "", "rgbFromLab", "lab", "commons"})
public final class ConvertersKt {
    @NotNull
    public static final Color rgbFromHcl(@NotNull HCL hcl, double alpha) {
        Intrinsics.checkNotNullParameter((Object)hcl, (String)"hcl");
        LUV luv = ConvertersKt.luvFromHcl(hcl);
        XYZ xyz = LUVKt.xyzFromLuv(luv);
        Color rgb = XYZKt.rgbFromXyz(xyz);
        return rgb.changeAlpha(MathKt.roundToInt((double)((double)255 * alpha)));
    }

    public static /* synthetic */ Color rgbFromHcl$default(HCL hCL, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        return ConvertersKt.rgbFromHcl(hCL, d);
    }

    @NotNull
    public static final Color rgbFromLab(@NotNull LAB lab, double alpha) {
        Intrinsics.checkNotNullParameter((Object)lab, (String)"lab");
        XYZ xyz = LABKt.xyzFromLab(lab);
        Color rgb = XYZKt.rgbFromXyz(xyz);
        return rgb.changeAlpha(MathKt.roundToInt((double)((double)255 * alpha)));
    }

    public static /* synthetic */ Color rgbFromLab$default(LAB lAB, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        return ConvertersKt.rgbFromLab(lAB, d);
    }

    @NotNull
    public static final HCL hclFromRgb(@NotNull Color rgb) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        XYZ xyz = XYZKt.xyzFromRgb(rgb);
        LUV luv = LUVKt.luvFromXyz(xyz);
        HCL hcl = ConvertersKt.hclFromLuv(luv);
        return hcl;
    }

    @NotNull
    public static final LAB labFromRgb(@NotNull Color rgb) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        XYZ xyz = XYZKt.xyzFromRgb(rgb);
        LAB lab = LABKt.labFromXyz(xyz);
        return lab;
    }

    @NotNull
    public static final HCL hclFromLuv(@NotNull LUV luv) {
        Intrinsics.checkNotNullParameter((Object)luv, (String)"luv");
        double c = Math.sqrt(luv.getU() * luv.getU() + luv.getV() * luv.getV());
        double h = org.jetbrains.letsPlot.commons.intern.math.MathKt.toDegrees(Math.atan2(luv.getV(), luv.getU())) % 360.0;
        return new HCL(h < 0.0 ? h + 360.0 : h, c, luv.getL());
    }

    @NotNull
    public static final LUV luvFromHcl(@NotNull HCL hcl) {
        Intrinsics.checkNotNullParameter((Object)hcl, (String)"hcl");
        double hDegrees = org.jetbrains.letsPlot.commons.intern.math.MathKt.toRadians(hcl.getH());
        double u = hcl.getC() * Math.cos(hDegrees);
        double v = hcl.getC() * Math.sin(hDegrees);
        return new LUV(hcl.getL(), u, v);
    }
}

