/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.geometry;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0000J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0006\u0010\u0014\u001a\u00020\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "", "start", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "end", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "getEnd", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getStart", "distance", "", "v", "equals", "", "other", "hashCode", "", "intersection", "with", "isDistanceToLineBest", "length", "toString", "", "commons"})
public final class DoubleSegment {
    @NotNull
    private final DoubleVector start;
    @NotNull
    private final DoubleVector end;

    public DoubleSegment(@NotNull DoubleVector start, @NotNull DoubleVector end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.end = end;
    }

    @NotNull
    public final DoubleVector getStart() {
        return this.start;
    }

    @NotNull
    public final DoubleVector getEnd() {
        return this.end;
    }

    public final double distance(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        DoubleVector vs = this.start.subtract(v);
        DoubleVector ve = this.end.subtract(v);
        if (this.isDistanceToLineBest(v)) {
            double pVolume = Math.abs(vs.getX() * ve.getY() - vs.getY() * ve.getX());
            return pVolume / this.length();
        }
        return Math.min(vs.length(), ve.length());
    }

    private final boolean isDistanceToLineBest(DoubleVector v) {
        DoubleVector es = this.start.subtract(this.end);
        DoubleVector se = es.negate();
        DoubleVector ev = v.subtract(this.end);
        DoubleVector sv = v.subtract(this.start);
        return es.dotProduct(ev) >= 0.0 && se.dotProduct(sv) >= 0.0;
    }

    @Nullable
    public final DoubleVector intersection(@NotNull DoubleSegment with) {
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        DoubleVector o1 = this.start;
        DoubleVector o2 = with.start;
        DoubleVector d1 = this.end.subtract(this.start);
        DoubleVector d2 = with.end.subtract(with.start);
        double td = d1.dotProduct(d2.orthogonal());
        if (td == 0.0) {
            return null;
        }
        double t = o2.subtract(o1).dotProduct(d2.orthogonal()) / td;
        if (t < 0.0 || t > 1.0) {
            return null;
        }
        double sd = d2.dotProduct(d1.orthogonal());
        double s = o1.subtract(o2).dotProduct(d1.orthogonal()) / sd;
        return s < 0.0 || s > 1.0 ? null : o1.add(d1.mul(t));
    }

    public final double length() {
        return this.start.subtract(this.end).length();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DoubleSegment)) {
            return false;
        }
        DoubleSegment l = (DoubleSegment)other;
        return l.start.equals(this.start) && l.end.equals(this.end);
    }

    public int hashCode() {
        return this.start.hashCode() * 31 + this.end.hashCode();
    }

    @NotNull
    public String toString() {
        return "" + '[' + this.start + " -> " + this.end + ']';
    }
}

