/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.text.DecimalFormat;
import java.util.Random;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoConfigMerge;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="displayName")
public class RandomVariableConfig
extends ConfigTestElement
implements TestBean,
LoopIterationListener,
NoThreadClone,
NoConfigMerge,
ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(RandomVariableConfig.class);
    private static final long serialVersionUID = 235L;
    private String minimumValue;
    private String maximumValue;
    private String variableName;
    private String outputFormat;
    private String randomSeed;
    private boolean perThread;
    private int range;
    private long minimum;
    private Random globalRandom = null;
    private transient ThreadLocal<Random> perThreadRandom = this.initThreadLocal();

    private ThreadLocal<Random> initThreadLocal() {
        return ThreadLocal.withInitial(() -> {
            this.init();
            return this.createRandom();
        });
    }

    private Object readResolve() {
        this.perThreadRandom = this.initThreadLocal();
        return this;
    }

    private void init() {
        String minAsString = this.getMinimumValue();
        this.minimum = NumberUtils.toLong((String)minAsString);
        String maxAsString = this.getMaximumValue();
        long maximum = NumberUtils.toLong((String)maxAsString);
        long rangeL = maximum - this.minimum + 1L;
        if (this.minimum > maximum) {
            log.error("maximum({}) must be >= minimum({})", (Object)maxAsString, (Object)minAsString);
            this.range = 0;
            return;
        }
        if (rangeL > Integer.MAX_VALUE || rangeL <= 0L) {
            log.warn("maximum({}) - minimum({}) must be <= {}", new Object[]{maxAsString, minAsString, Integer.MAX_VALUE});
            rangeL = Integer.MAX_VALUE;
        }
        this.range = (int)rangeL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterationStart(LoopIterationEvent iterEvent) {
        Random randGen;
        if (this.getPerThread()) {
            randGen = this.perThreadRandom.get();
        } else {
            RandomVariableConfig randomVariableConfig = this;
            synchronized (randomVariableConfig) {
                if (this.globalRandom == null) {
                    this.init();
                    this.globalRandom = this.createRandom();
                }
                randGen = this.globalRandom;
            }
        }
        if (this.range <= 0) {
            return;
        }
        long nextRand = this.minimum + (long)randGen.nextInt(this.range);
        JMeterVariables variables = JMeterContextService.getContext().getVariables();
        variables.put(this.getVariableName(), this.formatNumber(nextRand));
    }

    private String formatNumber(long value) {
        String format = this.getOutputFormat();
        if (format != null && format.length() > 0) {
            try {
                DecimalFormat myFormatter = new DecimalFormat(format);
                return myFormatter.format(value);
            }
            catch (IllegalArgumentException ignored) {
                log.warn("Exception formatting value: {} at format: {}, using default", (Object)value, (Object)format);
            }
        }
        return Long.toString(value);
    }

    public synchronized String getMinimumValue() {
        return this.minimumValue;
    }

    public synchronized void setMinimumValue(String minValue) {
        this.minimumValue = minValue;
    }

    public synchronized String getMaximumValue() {
        return this.maximumValue;
    }

    public synchronized void setMaximumValue(String maxvalue) {
        this.maximumValue = maxvalue;
    }

    public synchronized String getVariableName() {
        return this.variableName;
    }

    public synchronized void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public synchronized String getRandomSeed() {
        return this.randomSeed;
    }

    private Random createRandom() {
        Long seed;
        if (this.randomSeed.length() > 0 && (seed = this.getRandomSeedAsLong()) != null) {
            return new Random(seed);
        }
        return new Random();
    }

    private synchronized Long getRandomSeedAsLong() {
        Long seed;
        block2: {
            seed = null;
            try {
                seed = Long.parseLong(this.randomSeed);
            }
            catch (NumberFormatException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Cannot parse random seed: '{}' in element {}", (Object)this.randomSeed, (Object)this.getName());
            }
        }
        return seed;
    }

    public synchronized void setRandomSeed(String randomSeed) {
        this.randomSeed = randomSeed;
    }

    public synchronized boolean getPerThread() {
        return this.perThread;
    }

    public synchronized void setPerThread(boolean perThread) {
        this.perThread = perThread;
    }

    public synchronized String getOutputFormat() {
        return this.outputFormat;
    }

    public synchronized void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        this.perThreadRandom.remove();
    }
}

