/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jmespath.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import org.apache.jmeter.extractor.json.jmespath.JMESPathExtractor;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

@GUIMenuSortOrder(value=2)
@TestElementMetadata(labelResource="jmes_extractor_title")
public class JMESPathExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = -4825532539405119033L;
    private JLabeledTextField defaultValueField;
    private JLabeledTextField jmesPathExpressionField;
    private JLabeledTextField refNameField;
    private JLabeledTextField matchNumberField;

    public JMESPathExtractorGui() {
        this.init();
    }

    public String getLabelResource() {
        return "jmes_extractor_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        JMESPathExtractor config = (JMESPathExtractor)element;
        this.showScopeSettings(config, true);
        this.refNameField.setText(config.getRefName());
        this.jmesPathExpressionField.setText(config.getJmesPathExpression());
        this.matchNumberField.setText(config.getMatchNumber());
        this.defaultValueField.setText(config.getDefaultValue());
    }

    public TestElement createTestElement() {
        JMESPathExtractor config = new JMESPathExtractor();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement c) {
        super.configureTestElement(c);
        if (c instanceof JMESPathExtractor) {
            JMESPathExtractor config = (JMESPathExtractor)c;
            this.saveScopeSettings(config);
            config.setRefName(this.refNameField.getText());
            config.setJmesPathExpression(this.jmesPathExpressionField.getText());
            config.setDefaultValue(this.defaultValueField.getText());
            config.setMatchNumber(this.matchNumberField.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.refNameField.setText("");
        this.jmesPathExpressionField.setText("");
        this.matchNumberField.setText("");
        this.defaultValueField.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createScopePanel(true));
        this.add(box, "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeParameterPanel() {
        this.refNameField = new JLabeledTextField(JMeterUtils.getResString((String)"jsonpp_variable_names"));
        this.jmesPathExpressionField = new JLabeledTextField(JMeterUtils.getResString((String)"jmes_path_expressions"));
        this.matchNumberField = new JLabeledTextField(JMeterUtils.getResString((String)"jsonpp_match_numbers"));
        this.defaultValueField = new JLabeledTextField(JMeterUtils.getResString((String)"jsonpp_default_values"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JMESPathExtractorGui.initConstraints(gbc);
        JMESPathExtractorGui.addField(panel, this.refNameField, gbc);
        JMESPathExtractorGui.nextLine(gbc);
        JMESPathExtractorGui.addField(panel, this.jmesPathExpressionField, gbc);
        JMESPathExtractorGui.nextLine(gbc);
        JMESPathExtractorGui.addField(panel, this.matchNumberField, gbc);
        JMESPathExtractorGui.nextLine(gbc);
        JMESPathExtractorGui.nextLine(gbc);
        gbc.weighty = 1.0;
        JMESPathExtractorGui.addField(panel, this.defaultValueField, gbc);
        return panel;
    }

    private static void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private static void nextLine(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
    }

    private static void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

