/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.sampler.FixedQueueExecutor;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jmeter.protocol.jms.sampler.QueueExecutor;
import org.apache.jmeter.protocol.jms.sampler.Receiver;
import org.apache.jmeter.protocol.jms.sampler.TemporaryQueueExecutor;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSSampler
extends AbstractSampler
implements ThreadListener {
    private static final long serialVersionUID = 233L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JMSSampler.class);
    private static final String PREV_SAMPLER = "__PREV_SAMPLER__";
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final String DEFAULT_TIMEOUT_STRING = Integer.toString(2000);
    private static final String JNDI_INITIAL_CONTEXT_FACTORY = "JMSSampler.initialContextFactory";
    private static final String JNDI_CONTEXT_PROVIDER_URL = "JMSSampler.contextProviderUrl";
    private static final String JNDI_PROPERTIES = "JMSSampler.jndiProperties";
    private static final String TIMEOUT = "JMSSampler.timeout";
    private static final String JMS_PRIORITY = "JMSSampler.priority";
    private static final String JMS_EXPIRATION = "JMSSampler.expiration";
    private static final String JMS_SELECTOR = "JMSSampler.jmsSelector";
    private static final String JMS_SELECTOR_DEFAULT = "";
    @Deprecated
    public static final String IS_ONE_WAY = "JMSSampler.isFireAndForget";
    private static final String JMS_NUMBEROFSAMPLES = "JMSSampler.jmsNumberOfSamplesToAggregate";
    private static final String JMS_NUMBEROFSAMPLES_DEFAULT = "1";
    public static final String JMS_COMMUNICATION_STYLE = "JMSSampler.communicationStyle";
    private static final String JMS_PROPERTIES = "arguments";
    private static final String RECEIVE_QUEUE = "JMSSampler.ReceiveQueue";
    private static final String XML_DATA = "HTTPSamper.xml_data";
    private static final String SEND_QUEUE = "JMSSampler.SendQueue";
    private static final String QUEUE_CONNECTION_FACTORY_JNDI = "JMSSampler.queueconnectionfactory";
    private static final String IS_NON_PERSISTENT = "JMSSampler.isNonPersistent";
    private static final String USE_REQ_MSGID_AS_CORRELID = "JMSSampler.useReqMsgIdAsCorrelId";
    private static final String USE_RES_MSGID_AS_CORRELID = "JMSSampler.useResMsgIdAsCorrelId";
    private static final boolean USE_RES_MSGID_AS_CORRELID_DEFAULT = false;
    private static final boolean USE_SECURITY_PROPERTIES = JMeterUtils.getPropDefault((String)"JMSSampler.useSecurity.properties", (boolean)true);
    private transient Queue receiveQueue;
    private transient Queue sendQueue;
    private transient QueueSession session;
    private transient QueueConnection connection;
    private transient QueueExecutor executor;
    private transient QueueSender producer;
    private transient Receiver receiverThread = null;
    private transient Throwable thrown = null;
    private transient Context context = null;

    public SampleResult sample(Entry entry) {
        JMeterContext jmeterContext = JMeterContextService.getContext();
        SampleResult res = new SampleResult();
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.getContent());
        res.setSuccessful(false);
        res.setDataType("text");
        res.sampleStart();
        try {
            LOGGER.debug("Point-to-point mode: {}", (Object)this.getCommunicationstyle());
            if (this.isBrowse()) {
                this.handleBrowse(res);
            } else if (this.isClearQueue()) {
                this.handleClearQueue(res);
            } else if (this.isOneway()) {
                this.handleOneWay(res);
            } else if (this.isRead()) {
                this.handleRead(jmeterContext, res);
            } else {
                this.handleRequestResponse(res);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getLocalizedMessage(), (Throwable)e);
            if (this.thrown != null) {
                res.setResponseMessage(this.thrown.toString());
            }
            res.setResponseMessage(e.getLocalizedMessage());
        }
        res.sampleEnd();
        return res;
    }

    private void handleBrowse(SampleResult res) throws JMSException {
        LOGGER.debug("isBrowseOnly");
        StringBuilder sb = new StringBuilder(75);
        res.setSuccessful(true);
        sb.append("Browse message on Send Queue ").append(this.sendQueue.getQueueName()).append(": ").append(this.browseQueueDetails(this.sendQueue, res));
        res.setResponseData(sb.toString(), res.getDataEncodingWithDefault());
        res.setResponseCodeOK();
    }

    private void handleClearQueue(SampleResult res) throws JMSException {
        LOGGER.debug("isClearQueue");
        StringBuilder sb = new StringBuilder(75);
        res.setSuccessful(true);
        sb.append("Clear messages on Send Queue ").append(this.sendQueue.getQueueName()).append(": ").append(this.clearQueue(this.sendQueue, res));
        res.setResponseData(sb.toString(), res.getDataEncodingWithDefault());
        res.setResponseCodeOK();
    }

    private void handleOneWay(SampleResult res) throws JMSException {
        LOGGER.debug("isOneWay");
        TextMessage msg = this.createMessage();
        int deliveryMode = this.isNonPersistent() ? 1 : 2;
        this.producer.send((Message)msg, deliveryMode, Integer.parseInt(this.getPriority()), Long.parseLong(this.getExpiration()));
        res.setRequestHeaders(Utils.messageProperties((Message)msg));
        res.setResponseOK();
        res.setResponseData("Oneway request has no response data", null);
    }

    private void handleRead(JMeterContext context, SampleResult res) {
        String result;
        LOGGER.debug("isRead");
        StringBuilder sb = new StringBuilder(75);
        res.setSuccessful(true);
        Sampler sampler = context.getPreviousSampler();
        SampleResult sr = context.getPreviousResult();
        String jmsSelector = this.getJMSSelector();
        if (PREV_SAMPLER.equals(jmsSelector) && sampler instanceof JMSSampler) {
            jmsSelector = sr.getResponseMessage();
        }
        int sampleCounter = 0;
        int sampleTries = 0;
        StringBuilder buffer = new StringBuilder();
        StringBuilder propBuffer = new StringBuilder();
        do {
            if ((result = this.browseQueueForConsumption(this.sendQueue, jmsSelector, res, buffer, propBuffer)) == null) continue;
            sb.append(result);
            sb.append('\n');
            ++sampleCounter;
        } while (result != null && ++sampleTries < this.getNumberOfSamplesToAggregateAsInt());
        res.setResponseData(buffer.toString(), StandardCharsets.UTF_8.name());
        res.setResponseHeaders(propBuffer.toString());
        if (sampleCounter == 0) {
            res.setSuccessful(false);
            res.setResponseCode("404");
            res.setResponseMessage(sampleCounter + " samples messages received, last try had following response message:" + res.getResponseMessage());
        } else {
            res.setSuccessful(true);
            res.setResponseCodeOK();
            res.setResponseMessage(sampleCounter + " message(s) received successfully");
        }
        res.setSamplerData(this.getNumberOfSamplesToAggregateAsInt() + " messages expected");
        res.setSampleCount(sampleCounter);
    }

    private void handleRequestResponse(SampleResult res) throws JMSException {
        TextMessage msg = this.createMessage();
        if (!this.useTemporyQueue()) {
            LOGGER.debug("NO TEMP QUEUE");
            msg.setJMSReplyTo((Destination)this.receiveQueue);
        }
        LOGGER.debug("Create temp message");
        Message replyMsg = this.executor.sendAndReceive((Message)msg, this.isNonPersistent() ? 1 : 2, Integer.parseInt(this.getPriority()), Long.parseLong(this.getExpiration()));
        res.setRequestHeaders(Utils.messageProperties((Message)msg));
        if (replyMsg == null) {
            res.setResponseMessage("No reply message received");
        } else {
            if (replyMsg instanceof TextMessage) {
                res.setResponseData(((TextMessage)replyMsg).getText(), null);
            } else {
                res.setResponseData(replyMsg.toString(), null);
            }
            res.setResponseHeaders(Utils.messageProperties(replyMsg));
            res.setResponseOK();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String browseQueueForConsumption(Queue queue, String jmsSelector, SampleResult res, StringBuilder buffer, StringBuilder propBuffer) {
        QueueReceiver consumer;
        String retVal;
        block5: {
            retVal = null;
            consumer = null;
            Message reply = null;
            String queueName = null;
            try {
                queueName = queue.getQueueName();
                consumer = this.session.createReceiver(queue, jmsSelector);
                reply = consumer.receive((long)this.getTimeoutAsInt());
                LOGGER.debug("Message: {}", (Object)reply);
                if (reply != null) {
                    res.setResponseMessage("1 message received successfully");
                    res.setResponseHeaders(reply.toString());
                    TextMessage msg = (TextMessage)reply;
                    retVal = msg.getText();
                    JMSSampler.extractContent(buffer, propBuffer, (Message)msg);
                    break block5;
                }
                res.setResponseMessage("No message received");
            }
            catch (Exception ex) {
                try {
                    res.setResponseMessage("Error browsing queue '" + queueName + "' with selector '" + jmsSelector + "', timeout '" + this.getTimeout() + "', message:" + ex.getMessage());
                    LOGGER.error("Error browsing queue {} with selector {} and configured timeout {}", new Object[]{queueName, jmsSelector, this.getTimeout(), ex});
                }
                catch (Throwable throwable) {
                    Utils.close(consumer, LOGGER);
                    throw throwable;
                }
                Utils.close((MessageConsumer)consumer, LOGGER);
            }
        }
        Utils.close((MessageConsumer)consumer, LOGGER);
        return retVal;
    }

    private static void extractContent(StringBuilder buffer, StringBuilder propBuffer, Message msg) {
        if (msg != null) {
            try {
                if (msg instanceof TextMessage) {
                    buffer.append(((TextMessage)msg).getText());
                } else if (msg instanceof ObjectMessage) {
                    ObjectMessage objectMessage = (ObjectMessage)msg;
                    if (objectMessage.getObject() != null) {
                        buffer.append(objectMessage.getObject().getClass());
                    } else {
                        buffer.append("object is null");
                    }
                } else if (msg instanceof BytesMessage) {
                    BytesMessage bytesMessage = (BytesMessage)msg;
                    buffer.append(bytesMessage.getBodyLength() + " bytes received in BytesMessage");
                } else if (msg instanceof MapMessage) {
                    MapMessage mapm = (MapMessage)msg;
                    Enumeration enumb = mapm.getMapNames();
                    while (enumb.hasMoreElements()) {
                        String name = (String)enumb.nextElement();
                        Object obj = mapm.getObject(name);
                        buffer.append(name);
                        buffer.append(",");
                        buffer.append(obj.getClass().getCanonicalName());
                        buffer.append(",");
                        buffer.append(obj);
                        buffer.append("\n");
                    }
                }
                Utils.messageProperties(propBuffer, msg);
            }
            catch (JMSException e) {
                buffer.append("Error extracting content from message:" + e.getMessage());
                LOGGER.error("Error extracting content from message", (Throwable)e);
            }
        }
    }

    private String browseQueueDetails(Queue queue, SampleResult res) {
        String queueName = null;
        try {
            queueName = queue.getQueueName();
            StringBuilder messageBodies = new StringBuilder(150);
            messageBodies.append("==== Browsing Messages ===\n");
            QueueBrowser qBrowser = this.session.createBrowser(queue);
            Enumeration e = qBrowser.getEnumeration();
            int numMsgs = 0;
            while (e.hasMoreElements()) {
                TextMessage message = (TextMessage)e.nextElement();
                String corrID = message.getJMSCorrelationID();
                if (corrID == null) {
                    corrID = message.getJMSMessageID();
                    messageBodies.append(numMsgs).append(" - MessageID: ").append(corrID).append(": ").append(message.getText()).append("\n");
                } else {
                    messageBodies.append(numMsgs).append(" - CorrelationID: ").append(corrID).append(": ").append(message.getText()).append("\n");
                }
                ++numMsgs;
            }
            res.setResponseMessage(numMsgs + " messages available on the queue");
            res.setResponseHeaders(qBrowser.toString());
            return messageBodies + queue.getQueueName() + " has " + numMsgs + " messages";
        }
        catch (Exception e) {
            res.setResponseMessage("Error counting message on the queue");
            LOGGER.error("Error browsing messages on the queue {}", (Object)queueName, (Object)e);
            return "Error browsing messages on the queue, message " + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String clearQueue(Queue queue, SampleResult res) {
        String retVal = null;
        QueueReceiver consumer = null;
        String queueName = null;
        try {
            queueName = queue.getQueueName();
            consumer = this.session.createReceiver(queue);
            Message deletedMsg = null;
            long deletedMsgCount = 0L;
            do {
                if ((deletedMsg = consumer.receive((long)this.getTimeoutAsInt())) == null) continue;
                ++deletedMsgCount;
                deletedMsg.acknowledge();
            } while (deletedMsg != null);
            retVal = deletedMsgCount + " message(s) removed using receive timeout:" + this.getTimeoutAsInt() + "ms";
            res.setResponseMessage(retVal);
        }
        catch (Exception ex) {
            String string;
            try {
                res.setResponseMessage("Error clearing queue:" + queueName);
                LOGGER.error("Error clearing queue {}", (Object)queueName, (Object)ex);
                string = "Error clearing queue " + queueName + ", message:" + ex.getMessage();
            }
            catch (Throwable throwable) {
                Utils.close(consumer, LOGGER);
                throw throwable;
            }
            Utils.close((MessageConsumer)consumer, LOGGER);
            return string;
        }
        Utils.close((MessageConsumer)consumer, LOGGER);
        return retVal;
    }

    private TextMessage createMessage() throws JMSException {
        if (this.session == null) {
            throw new IllegalStateException("Session may not be null while creating message");
        }
        TextMessage msg = this.session.createTextMessage();
        msg.setText(this.getContent());
        this.addJMSProperties(msg);
        return msg;
    }

    private void addJMSProperties(TextMessage msg) throws JMSException {
        Utils.addJMSProperties((Message)msg, this.getJMSProperties().getJmsPropertysAsMap());
    }

    public JMSProperties getJMSProperties() {
        Object o = this.getProperty(JMS_PROPERTIES).getObjectValue();
        JMSProperties jmsProperties = null;
        jmsProperties = o instanceof Arguments ? Utils.convertArgumentsToJmsProperties((Arguments)o) : (JMSProperties)o;
        if (jmsProperties == null) {
            jmsProperties = new JMSProperties();
            this.setJMSProperties(jmsProperties);
        }
        return jmsProperties;
    }

    public void setJMSProperties(JMSProperties jmsProperties) {
        this.setProperty((JMeterProperty)new TestElementProperty(JMS_PROPERTIES, (TestElement)jmsProperties));
    }

    public Arguments getJNDIProperties() {
        return this.getArguments(JNDI_PROPERTIES);
    }

    public void setJNDIProperties(Arguments args) {
        this.setProperty((JMeterProperty)new TestElementProperty(JNDI_PROPERTIES, (TestElement)args));
    }

    public String getQueueConnectionFactory() {
        return this.getPropertyAsString(QUEUE_CONNECTION_FACTORY_JNDI);
    }

    public void setQueueConnectionFactory(String qcf) {
        this.setProperty(QUEUE_CONNECTION_FACTORY_JNDI, qcf);
    }

    public String getSendQueue() {
        return this.getPropertyAsString(SEND_QUEUE);
    }

    public void setSendQueue(String name) {
        this.setProperty(SEND_QUEUE, name);
    }

    public String getReceiveQueue() {
        return this.getPropertyAsString(RECEIVE_QUEUE);
    }

    public void setReceiveQueue(String name) {
        this.setProperty(RECEIVE_QUEUE, name);
    }

    public String getContent() {
        return this.getPropertyAsString(XML_DATA);
    }

    public void setContent(String content) {
        this.setProperty(XML_DATA, content);
    }

    public boolean isOneway() {
        return COMMUNICATION_STYLE.ONE_WAY.value == this.getPropertyAsInt(JMS_COMMUNICATION_STYLE);
    }

    public boolean isRead() {
        return COMMUNICATION_STYLE.READ.value == this.getPropertyAsInt(JMS_COMMUNICATION_STYLE);
    }

    public boolean isBrowse() {
        return COMMUNICATION_STYLE.BROWSE.value == this.getPropertyAsInt(JMS_COMMUNICATION_STYLE);
    }

    public boolean isClearQueue() {
        return COMMUNICATION_STYLE.CLEAR.value == this.getPropertyAsInt(JMS_COMMUNICATION_STYLE);
    }

    public boolean isNonPersistent() {
        return this.getPropertyAsBoolean(IS_NON_PERSISTENT);
    }

    public boolean isUseReqMsgIdAsCorrelId() {
        return this.getPropertyAsBoolean(USE_REQ_MSGID_AS_CORRELID);
    }

    public boolean isUseResMsgIdAsCorrelId() {
        return this.getPropertyAsBoolean(USE_RES_MSGID_AS_CORRELID, false);
    }

    public String getInitialContextFactory() {
        return this.getPropertyAsString(JNDI_INITIAL_CONTEXT_FACTORY);
    }

    public String getContextProvider() {
        return this.getPropertyAsString(JNDI_CONTEXT_PROVIDER_URL);
    }

    public int getCommunicationstyle() {
        JMeterProperty prop = this.getProperty(JMS_COMMUNICATION_STYLE);
        return prop.getIntValue();
    }

    public String getCommunicationstyleString() {
        return this.getPropertyAsString(JMS_COMMUNICATION_STYLE);
    }

    public void setCommunicationstyle(int communicationStyle) {
        this.setProperty((JMeterProperty)new IntegerProperty(JMS_COMMUNICATION_STYLE, communicationStyle));
    }

    public void setIsOneway(boolean isOneway) {
        this.setProperty((JMeterProperty)new IntegerProperty(JMS_COMMUNICATION_STYLE, isOneway ? COMMUNICATION_STYLE.ONE_WAY.value : COMMUNICATION_STYLE.REQUEST_REPLY.value));
    }

    public void setNonPersistent(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(IS_NON_PERSISTENT, value));
    }

    public void setUseReqMsgIdAsCorrelId(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(USE_REQ_MSGID_AS_CORRELID, value));
    }

    public void setUseResMsgIdAsCorrelId(boolean value) {
        this.setProperty(USE_RES_MSGID_AS_CORRELID, value, false);
    }

    public String toString() {
        return this.getQueueConnectionFactory() + ", queue: " + this.getSendQueue();
    }

    public void threadStarted() {
        this.logThreadStart();
        this.thrown = null;
        try {
            this.context = this.getInitialContext();
            Object obj = this.context.lookup(this.getQueueConnectionFactory());
            if (!(obj instanceof QueueConnectionFactory)) {
                String msg = "QueueConnectionFactory expected, but got " + (obj != null ? obj.getClass().getName() : "null");
                LOGGER.error(msg);
                throw new IllegalStateException(msg);
            }
            QueueConnectionFactory factory = (QueueConnectionFactory)obj;
            this.sendQueue = (Queue)this.context.lookup(this.getSendQueue());
            if (!this.useTemporyQueue()) {
                this.receiveQueue = (Queue)this.context.lookup(this.getReceiveQueue());
                this.receiverThread = Receiver.createReceiver((ConnectionFactory)factory, (Destination)this.receiveQueue, Utils.getFromEnvironment(this.context, "java.naming.security.principal"), Utils.getFromEnvironment(this.context, "java.naming.security.credentials"), this.isUseResMsgIdAsCorrelId(), this.getJMSSelector());
            }
            String principal = null;
            String credentials = null;
            if (USE_SECURITY_PROPERTIES) {
                principal = Utils.getFromEnvironment(this.context, "java.naming.security.principal");
                credentials = Utils.getFromEnvironment(this.context, "java.naming.security.credentials");
            }
            this.connection = principal != null && credentials != null ? factory.createQueueConnection(principal, credentials) : factory.createQueueConnection();
            this.session = this.connection.createQueueSession(false, 1);
            LOGGER.debug("Session created");
            if (!(this.isBrowse() || this.isRead() || this.isClearQueue())) {
                if (this.isOneway()) {
                    this.producer = this.session.createSender(this.sendQueue);
                    if (this.isNonPersistent()) {
                        this.producer.setDeliveryMode(1);
                    }
                    this.producer.setPriority(Integer.parseInt(this.getPriority()));
                    this.producer.setTimeToLive(Long.parseLong(this.getExpiration()));
                } else if (this.useTemporyQueue()) {
                    this.executor = new TemporaryQueueExecutor(this.session, this.sendQueue, this.getTimeoutAsInt());
                } else {
                    this.producer = this.session.createSender(this.sendQueue);
                    this.executor = new FixedQueueExecutor((MessageProducer)this.producer, this.getTimeoutAsInt(), this.isUseReqMsgIdAsCorrelId());
                }
            }
            LOGGER.debug("Starting connection");
            this.connection.start();
            LOGGER.debug("Connection started");
        }
        catch (Exception | NoClassDefFoundError e) {
            this.thrown = e;
            LOGGER.error(e.getLocalizedMessage(), e);
        }
    }

    private Context getInitialContext() throws NamingException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (this.getInitialContextFactory() != null && this.getInitialContextFactory().trim().length() > 0) {
            LOGGER.debug("Using InitialContext [{}]", (Object)this.getInitialContextFactory());
            table.put("java.naming.factory.initial", this.getInitialContextFactory());
        }
        if (this.getContextProvider() != null && this.getContextProvider().trim().length() > 0) {
            LOGGER.debug("Using Provider [{}]", (Object)this.getContextProvider());
            table.put("java.naming.provider.url", this.getContextProvider());
        }
        Map map = this.getArguments(JNDI_PROPERTIES).getArgumentsAsMap();
        if (LOGGER.isDebugEnabled()) {
            if (map.isEmpty()) {
                LOGGER.debug("Empty JNDI properties");
            } else {
                LOGGER.debug("Number of JNDI properties: {}", (Object)map.size());
            }
        }
        for (Map.Entry me : map.entrySet()) {
            table.put((String)me.getKey(), (String)me.getValue());
        }
        InitialContext initialContext = new InitialContext(table);
        if (LOGGER.isDebugEnabled()) {
            JMSSampler.printEnvironment(initialContext);
        }
        return initialContext;
    }

    private static void printEnvironment(Context context) throws NamingException {
        try {
            Hashtable<?, ?> env = context.getEnvironment();
            if (env != null) {
                LOGGER.debug("Initial Context Properties");
                for (Map.Entry<?, ?> entry : env.entrySet()) {
                    LOGGER.debug("{}={}", entry.getKey(), entry.getValue());
                }
            } else {
                LOGGER.warn("context.getEnvironment() returned null (should not happen according to javadoc but non compliant implementation can return this)");
            }
        }
        catch (OperationNotSupportedException ex) {
            LOGGER.warn("context.getEnvironment() not supported by implementation ");
        }
    }

    private static String formatLikeDate(Instant instant) {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withLocale(Locale.ROOT).withZone(ZoneId.systemDefault()).format(instant);
    }

    private void logThreadStart() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Thread started {}", (Object)JMSSampler.formatLikeDate(Instant.now()));
            LOGGER.debug("JMSSampler: [{}], hashCode=[{}]", (Object)Thread.currentThread().getName(), (Object)this.hashCode());
            LOGGER.debug("QCF: [{}], sendQueue=[{}]", (Object)this.getQueueConnectionFactory(), (Object)this.getSendQueue());
            LOGGER.debug("Timeout = [{}]", (Object)this.getTimeout());
            LOGGER.debug("Use temporary queue =[{}]", (Object)this.useTemporyQueue());
            LOGGER.debug("Reply queue         = [{}]", (Object)this.getReceiveQueue());
        }
    }

    private int getTimeoutAsInt() {
        String propAsString = this.getPropertyAsString(TIMEOUT);
        if (StringUtils.isEmpty((CharSequence)propAsString)) {
            return 2000;
        }
        return Integer.parseInt(propAsString);
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT, DEFAULT_TIMEOUT_STRING);
    }

    public String getExpiration() {
        String expiration = this.getPropertyAsString(JMS_EXPIRATION);
        if (expiration.length() == 0) {
            return "0";
        }
        return expiration;
    }

    public String getPriority() {
        String priority = this.getPropertyAsString(JMS_PRIORITY);
        if (priority.length() == 0) {
            return "4";
        }
        return priority;
    }

    public void threadFinished() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Thread ended {}", (Object)JMSSampler.formatLikeDate(Instant.now()));
        }
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (this.executor != null) {
            try {
                this.executor.close();
            }
            catch (JMSException e) {
                LOGGER.error("Error closing executor {}", this.executor.getClass(), (Object)e);
            }
        }
        Utils.close((Session)this.session, LOGGER);
        Utils.close((Connection)this.connection, LOGGER);
        if (this.receiverThread != null) {
            this.receiverThread.deactivate();
        }
    }

    private boolean useTemporyQueue() {
        String recvQueue = this.getReceiveQueue();
        return recvQueue == null || recvQueue.trim().length() == 0;
    }

    public void setArguments(Arguments args) {
        this.setProperty((JMeterProperty)new TestElementProperty(JMS_PROPERTIES, (TestElement)args));
    }

    public Arguments getArguments(String name) {
        return (Arguments)this.getProperty(name).getObjectValue();
    }

    public void setTimeout(String s) {
        this.setProperty(TIMEOUT, s);
    }

    public void setPriority(String s) {
        this.setProperty(JMS_PRIORITY, s, "4");
    }

    public void setExpiration(String s) {
        this.setProperty(JMS_EXPIRATION, s, "0");
    }

    public String getJMSSelector() {
        return this.getPropertyAsString(JMS_SELECTOR, JMS_SELECTOR_DEFAULT);
    }

    public void setJMSSelector(String selector) {
        this.setProperty(JMS_SELECTOR, selector, JMS_SELECTOR_DEFAULT);
    }

    public String getNumberOfSamplesToAggregate() {
        return this.getPropertyAsString(JMS_NUMBEROFSAMPLES, JMS_NUMBEROFSAMPLES_DEFAULT);
    }

    public void setNumberOfSamplesToAggregate(String selector) {
        this.setProperty(JMS_NUMBEROFSAMPLES, selector, JMS_NUMBEROFSAMPLES_DEFAULT);
    }

    private int getNumberOfSamplesToAggregateAsInt() {
        int val = 1;
        try {
            val = this.getPropertyAsInt(JMS_NUMBEROFSAMPLES);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed parsing number of samples to aggregate");
            }
            val = 1;
        }
        if (val < 1) {
            val = 1;
        }
        return val;
    }

    public void setInitialContextFactory(String string) {
        this.setProperty(JNDI_INITIAL_CONTEXT_FACTORY, string);
    }

    public void setContextProvider(String string) {
        this.setProperty(JNDI_CONTEXT_PROVIDER_URL, string);
    }

    public static enum COMMUNICATION_STYLE {
        ONE_WAY(0),
        REQUEST_REPLY(1),
        READ(2),
        BROWSE(3),
        CLEAR(4);

        private final int value;

        private COMMUNICATION_STYLE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

