/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.pixels;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.Deflater;
import org.jetbrains.letsPlot.util.pngj.IdatChunkWriter;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;
import org.jetbrains.letsPlot.util.pngj.pixels.CompressorStream;
import org.jetbrains.letsPlot.util.pngj.pixels.DeflaterEstimatorLz4;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB1\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/CompressorStreamLz4;", "Lorg/jetbrains/letsPlot/util/pngj/pixels/CompressorStream;", "os", "Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;", "maxBlockLen", "", "totalLen", "", "def", "Lorg/jetbrains/letsPlot/util/pngj/Deflater;", "(Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;IJLorg/jetbrains/letsPlot/util/pngj/Deflater;)V", "deflaterCompLevel", "deflaterStrategy", "(Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;IJII)V", "(Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;IJ)V", "buf", "", "buffer_size", "inbuf", "lz4", "Lorg/jetbrains/letsPlot/util/pngj/pixels/DeflaterEstimatorLz4;", "close", "", "compressFromBuffer", "done", "mywrite", "data", "off", "len", "Companion", "plot-api"})
public final class CompressorStreamLz4
extends CompressorStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeflaterEstimatorLz4 lz4;
    @Nullable
    private byte[] buf;
    private final int buffer_size;
    private int inbuf;
    private static final int MAX_BUFFER_SIZE = 16000;

    public CompressorStreamLz4(@Nullable IdatChunkWriter os, int maxBlockLen, long totalLen) {
        super(os, maxBlockLen, totalLen);
        this.lz4 = new DeflaterEstimatorLz4();
        this.buffer_size = ((Number)(totalLen > 16000L ? (Number)16000 : (Number)totalLen)).intValue();
    }

    public CompressorStreamLz4(@Nullable IdatChunkWriter os, int maxBlockLen, long totalLen, @NotNull Deflater def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        this(os, maxBlockLen, totalLen);
    }

    public CompressorStreamLz4(@Nullable IdatChunkWriter os, int maxBlockLen, long totalLen, int deflaterCompLevel, int deflaterStrategy) {
        this(os, maxBlockLen, totalLen);
    }

    @Override
    public void mywrite(@NotNull byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int off2 = off;
        int len2 = len;
        if (len2 == 0) {
            return;
        }
        if (this.isDone() || this.isClosed()) {
            throw new PngjOutputException("write beyond end of stream");
        }
        this.setBytesIn(this.getBytesIn() + (long)len2);
        while (len2 > 0) {
            int len1;
            if (this.inbuf == 0 && (len2 >= 16000 || this.getBytesIn() == this.getTotalbytes())) {
                this.setBytesOut(this.getBytesOut() + (long)this.lz4.compressEstim(data, off2, len2));
                len2 = 0;
                continue;
            }
            if (this.buf == null) {
                this.buf = new byte[this.buffer_size];
            }
            int n = len1 = this.inbuf + len2 <= this.buffer_size ? len2 : this.buffer_size - this.inbuf;
            if (len1 > 0) {
                Intrinsics.checkNotNull((Object)this.buf);
                ArrayUtilsKt.arraycopy(data, off2, this.buf, this.inbuf, len1);
            }
            this.inbuf += len1;
            len2 -= len1;
            off2 += len1;
            if (this.inbuf != this.buffer_size) continue;
            this.compressFromBuffer();
        }
    }

    private final void compressFromBuffer() {
        if (this.inbuf > 0) {
            long l = this.getBytesOut();
            Intrinsics.checkNotNull((Object)this.buf);
            this.setBytesOut(l + (long)this.lz4.compressEstim(this.buf, 0, this.inbuf));
            this.inbuf = 0;
        }
    }

    @Override
    public void done() {
        if (!this.isDone()) {
            this.compressFromBuffer();
            this.setDone(true);
        }
    }

    @Override
    public void close() {
        this.done();
        if (!this.isClosed()) {
            super.close();
            this.buf = null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/CompressorStreamLz4$Companion;", "", "()V", "MAX_BUFFER_SIZE", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

