/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ArgumentSchema;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jorphan.util.JOrphanUtils;

public class Argument
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    public static final String ARG_NAME = "Argument.name";
    public static final String VALUE = "Argument.value";
    public static final String DESCRIPTION = "Argument.desc";
    public static final String METADATA = "Argument.metadata";

    public Argument() {
        this(null, null, null, null);
    }

    public Argument(String name, String value) {
        this(name, value, null, null);
    }

    public Argument(String name, String value, String metadata) {
        this(name, value, metadata, null);
    }

    public Argument(String name, String value, String metadata, String description) {
        if (name != null) {
            this.setName(name);
        }
        if (value != null) {
            this.setValue(value);
        }
        if (metadata != null) {
            this.setMetaData(metadata);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public ArgumentSchema getSchema() {
        return ArgumentSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends Argument, ? extends ArgumentSchema> getProps() {
        return new PropertiesAccessor<Argument, ArgumentSchema>(this, this.getSchema());
    }

    @Override
    public void setName(String newName) {
        this.set(this.getSchema().getArgumentName(), StringUtils.strip((String)newName));
    }

    @Override
    public String getName() {
        return this.get(this.getSchema().getArgumentName());
    }

    public void setValue(String newValue) {
        this.set(this.getSchema().getValue(), newValue);
    }

    public String getValue() {
        return this.get(this.getSchema().getValue());
    }

    public void setDescription(String description) {
        this.set(this.getSchema().getDescription(), description);
    }

    public String getDescription() {
        return this.get(this.getSchema().getDescription());
    }

    public void setMetaData(String newMetaData) {
        this.set(this.getSchema().getMetadata(), newMetaData);
    }

    public String getMetaData() {
        return this.get(this.getSchema().getMetadata());
    }

    public String toString() {
        String desc = this.getDescription();
        if (desc == null || desc.isEmpty()) {
            return this.getName() + this.getMetaData() + this.getValue();
        }
        return this.getName() + this.getMetaData() + this.getValue() + " //" + this.getDescription();
    }

    public boolean isSkippable(String parameterName) {
        if (JOrphanUtils.isBlank((String)parameterName)) {
            return true;
        }
        return parameterName.trim().startsWith("${") && parameterName.endsWith("}");
    }
}

