/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.StreamException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractActionWithNoRunningTest;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Close;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Command.class})
public class Load
extends AbstractActionWithNoRunningTest {
    private static final Logger log = LoggerFactory.getLogger(Load.class);
    private static final boolean EXPAND_TREE = JMeterUtils.getPropDefault("onload.expandtree", false);
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doActionAfterCheck(ActionEvent e) {
        JFileChooser chooser = FileDialoger.promptToOpenFile(new String[]{".jmx"});
        if (chooser == null) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile != null) {
            boolean merging = e.getActionCommand().equals("merge");
            if (!merging && !Close.performAction(e)) {
                return;
            }
            Load.loadProjectFile(e, selectedFile, merging);
        }
    }

    static void loadProjectFile(ActionEvent e, File f, boolean merging) {
        Load.loadProjectFile(e, f, merging, true);
    }

    static void loadProjectFile(ActionEvent e, File f, boolean merging, boolean setDetails) {
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "stop_thread"));
        GuiPackage guiPackage = GuiPackage.getInstance();
        if (f != null) {
            try {
                if (merging) {
                    log.info("Merging file: {}", (Object)f);
                } else {
                    log.info("Loading file: {}", (Object)f);
                    if (setDetails) {
                        FileServer.getFileServer().setBaseForScript(f);
                    }
                }
                HashTree tree = SaveService.loadTree(f);
                boolean isTestPlan = Load.insertLoadedTree(e.getID(), tree, merging);
                if (!merging && isTestPlan && setDetails) {
                    guiPackage.setTestPlanFile(f.getAbsolutePath());
                }
            }
            catch (NoClassDefFoundError ex) {
                Load.reportError("Missing jar file. {}", ex, true);
            }
            catch (ConversionException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Could not convert file. {}", (Object)ex.toString());
                }
                JMeterUtils.reportErrorToUser(SaveService.CEtoString(ex));
            }
            catch (IOException ex) {
                Load.reportError("Error reading file. {}", ex, false);
            }
            catch (StreamException ex) {
                Throwable exceptionToDisplay = ex;
                if ("".equals(ex.getMessage()) && ex.getCause() != null) {
                    exceptionToDisplay = ex.getCause();
                }
                Load.reportError("Error in XML format. {}", exceptionToDisplay, false);
            }
            catch (Exception ex) {
                Load.reportError("Unexpected error. {}", ex, true);
            }
            FileDialoger.setLastJFCDirectory(f.getParentFile().getAbsolutePath());
            guiPackage.updateCurrentGui();
            guiPackage.getMainFrame().repaint();
        }
    }

    public static boolean insertLoadedTree(int id, HashTree tree, boolean merging) throws IllegalUserActionException {
        boolean ok;
        TestElement te;
        if (tree == null) {
            throw new IllegalUserActionException("Empty TestPlan or error reading test plan - see log file");
        }
        boolean isTestPlan = tree.getArray()[0] instanceof TestPlan;
        GuiPackage guiInstance = GuiPackage.getInstance();
        if (isTestPlan && !merging) {
            guiInstance.clearTestPlan((TestElement)tree.getArray()[0]);
        }
        if (merging && !((te = (TestElement)tree.getArray()[0]) instanceof TestPlan) && !(ok = MenuFactory.canAddTo(guiInstance.getCurrentNode(), te))) {
            String name = te.getName();
            String className = te.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            throw new IllegalUserActionException("Can't merge " + name + " (" + className + ") here");
        }
        HashTree newTree = guiInstance.addSubTree(tree);
        guiInstance.updateCurrentGui();
        guiInstance.getMainFrame().getTree().setSelectionPath(new TreePath(((JMeterTreeNode)newTree.getArray()[0]).getPath()));
        HashTree subTree = guiInstance.getCurrentSubTree();
        ActionEvent actionEvent = new ActionEvent(subTree.get(subTree.getArray()[subTree.size() - 1]), id, merging ? "sub_tree_merged" : "sub_tree_loaded");
        ActionRouter.getInstance().actionPerformed(actionEvent);
        JTree jTree = guiInstance.getMainFrame().getTree();
        if (EXPAND_TREE && !merging) {
            for (int i = 0; i < jTree.getRowCount(); ++i) {
                jTree.expandRow(i);
            }
        } else {
            jTree.expandRow(0);
        }
        jTree.setSelectionPath(jTree.getPathForRow(1));
        FocusRequester.requestFocus(jTree);
        return isTestPlan;
    }

    public static boolean insertLoadedTree(int id, HashTree tree) throws IllegalUserActionException {
        return Load.insertLoadedTree(id, tree, false);
    }

    private static void reportError(String messageFormat, Throwable ex, boolean stackTrace) {
        String msg;
        if (log.isWarnEnabled()) {
            if (stackTrace) {
                log.warn(messageFormat, (Object)ex.toString(), (Object)ex);
            } else {
                log.warn(messageFormat, (Object)ex.toString());
            }
        }
        if ((msg = ex.getMessage()) == null) {
            msg = "Unexpected error - see log for details";
        }
        JMeterUtils.reportErrorToUser(msg);
    }

    static {
        commands.add("open");
        commands.add("merge");
    }
}

