/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;

public class PropertyIteratorImpl
implements PropertyIterator {
    public static final PropertyIterator EMPTY_ITERATOR = new PropertyIteratorImpl(Collections.emptyList());
    private final TestElement owner;
    private final Iterator<? extends JMeterProperty> iter;
    private String lastPropertyName;

    public PropertyIteratorImpl(Collection<JMeterProperty> value) {
        this(null, value);
    }

    public PropertyIteratorImpl(TestElement owner, Iterable<? extends JMeterProperty> properties) {
        this.owner = owner;
        this.iter = properties.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public JMeterProperty next() {
        JMeterProperty last = this.iter.next();
        if (this.owner != null) {
            this.lastPropertyName = last.getName();
        }
        return last;
    }

    @Override
    public void remove() {
        this.iter.remove();
        if (this.lastPropertyName != null) {
            this.owner.removeProperty(this.lastPropertyName);
            this.lastPropertyName = null;
        }
    }
}

