/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.Serializable;
import java.time.Duration;
import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.IteratingController;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.threads.AbstractThreadGroupSchema;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.TestCompilerHelper;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractThreadGroup
extends AbstractTestElement
implements Serializable,
Controller,
JMeterThreadMonitor,
TestCompilerHelper {
    private static final long serialVersionUID = 240L;
    private final transient IdentityHashMap<TestElement, Object> children = new IdentityHashMap();
    private static final Object DUMMY = new Object();
    public static final Duration DEFAULT_THREAD_STOP_TIMEOUT = Duration.ofMillis(JMeterUtils.getPropDefault("jmeterengine.threadstop.wait", 5000L));
    public static final String ON_SAMPLE_ERROR = "ThreadGroup.on_sample_error";
    public static final String ON_SAMPLE_ERROR_CONTINUE = "continue";
    public static final String ON_SAMPLE_ERROR_START_NEXT_LOOP = "startnextloop";
    public static final String ON_SAMPLE_ERROR_STOPTHREAD = "stopthread";
    public static final String ON_SAMPLE_ERROR_STOPTEST = "stoptest";
    public static final String ON_SAMPLE_ERROR_STOPTEST_NOW = "stoptestnow";
    public static final String NUM_THREADS = "ThreadGroup.num_threads";
    public static final String MAIN_CONTROLLER = "ThreadGroup.main_controller";
    public static final String IS_SAME_USER_ON_NEXT_ITERATION = "ThreadGroup.same_user_on_next_iteration";
    private final AtomicInteger numberOfThreads = new AtomicInteger(0);

    @Override
    public AbstractThreadGroupSchema getSchema() {
        return AbstractThreadGroupSchema.INSTANCE;
    }

    @NotNull
    public PropertiesAccessor<? extends AbstractThreadGroup, ? extends AbstractThreadGroupSchema> getProps() {
        return new PropertiesAccessor<AbstractThreadGroup, AbstractThreadGroupSchema>(this, this.getSchema());
    }

    @Override
    public boolean isDone() {
        return this.getSamplerController().isDone();
    }

    @Override
    public Sampler next() {
        return this.getSamplerController().next();
    }

    public Controller getSamplerController() {
        return this.get(this.getSchema().getMainController());
    }

    public void setSamplerController(LoopController c) {
        c.setContinueForever(false);
        this.set(this.getSchema().getMainController(), c);
    }

    @Override
    public void addTestElement(TestElement child) {
        this.getSamplerController().addTestElement(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addTestElementOnce(TestElement child) {
        IdentityHashMap<TestElement, Object> identityHashMap = this.children;
        synchronized (identityHashMap) {
            if (this.children.putIfAbsent(child, DUMMY) == null) {
                this.addTestElement(child);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addIterationListener(LoopIterationListener lis) {
        this.getSamplerController().addIterationListener(lis);
    }

    @Override
    public void removeIterationListener(LoopIterationListener iterationListener) {
        this.getSamplerController().removeIterationListener(iterationListener);
    }

    @Override
    public void initialize() {
        Controller c = this.getSamplerController();
        JMeterProperty property = c.getProperty("TestElement.name");
        property.setObjectValue(this.getName());
        property.setRunningVersion(property.isRunningVersion());
        c.initialize();
    }

    public void startNextLoop() {
        ((IteratingController)((Object)this.getSamplerController())).startNextLoop();
    }

    @Override
    public void triggerEndOfLoop() {
    }

    public void setNumThreads(int numThreads) {
        this.set(this.getSchema().getNumThreads(), numThreads);
    }

    void incrNumberOfThreads() {
        this.numberOfThreads.incrementAndGet();
    }

    void decrNumberOfThreads() {
        this.numberOfThreads.decrementAndGet();
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads.get();
    }

    public int getNumThreads() {
        return this.get(this.getSchema().getNumThreads());
    }

    private String getOnSampleError() {
        return this.get(this.getSchema().getOnSampleError());
    }

    public boolean getOnErrorStartNextLoop() {
        return this.getOnSampleError().equalsIgnoreCase(ON_SAMPLE_ERROR_START_NEXT_LOOP);
    }

    public boolean getOnErrorStopThread() {
        return this.getOnSampleError().equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTHREAD);
    }

    public boolean getOnErrorStopTest() {
        return this.getOnSampleError().equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTEST);
    }

    public boolean getOnErrorStopTestNow() {
        return this.getOnSampleError().equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTEST_NOW);
    }

    public abstract boolean stopThread(String var1, boolean var2);

    public abstract int numberOfActiveThreads();

    public abstract void start(int var1, ListenerNotifier var2, ListedHashTree var3, StandardJMeterEngine var4);

    public abstract JMeterThread addNewThread(int var1, StandardJMeterEngine var2);

    public abstract boolean verifyThreadsStopped();

    public abstract void waitThreadsStopped();

    public abstract void tellThreadsToStop();

    public abstract void stop();

    public void breakThreadLoop() {
        ((IteratingController)((Object)this.getSamplerController())).breakLoop();
    }

    public void setIsSameUserOnNextIteration(boolean isSameUserOnNextIteration) {
        this.set(this.getSchema().getSameUserOnNextIteration(), isSameUserOnNextIteration);
    }

    public boolean isSameUserOnNextIteration() {
        return this.get(this.getSchema().getSameUserOnNextIteration());
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.5")
    protected JMeterThread makeThread(StandardJMeterEngine engine, JMeterThreadMonitor monitor, ListenerNotifier notifier, int groupNumber, int threadNumber, ListedHashTree threadGroupTree, JMeterVariables variables) {
        boolean onErrorStopTest = this.getOnErrorStopTest();
        boolean onErrorStopTestNow = this.getOnErrorStopTestNow();
        boolean onErrorStopThread = this.getOnErrorStopThread();
        boolean onErrorStartNextLoop = this.getOnErrorStartNextLoop();
        String groupName = this.getName();
        JMeterThread jmeterThread = new JMeterThread((HashTree)threadGroupTree, monitor, notifier, this.isSameUserOnNextIteration());
        jmeterThread.setThreadNum(threadNumber);
        jmeterThread.setThreadGroup(this);
        jmeterThread.putVariables(variables);
        String distributedPrefix = JMeterUtils.getPropDefault("__jm.D_TG", "");
        String threadName = distributedPrefix + (distributedPrefix.isEmpty() ? "" : "-") + groupName + " " + groupNumber + "-" + (threadNumber + 1);
        jmeterThread.setThreadName(threadName);
        jmeterThread.setEngine(engine);
        jmeterThread.setOnErrorStopTest(onErrorStopTest);
        jmeterThread.setOnErrorStopTestNow(onErrorStopTestNow);
        jmeterThread.setOnErrorStopThread(onErrorStopThread);
        jmeterThread.setOnErrorStartNextLoop(onErrorStartNextLoop);
        return jmeterThread;
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.5")
    public static ListedHashTree cloneTree(ListedHashTree tree) {
        TreeCloner cloner = new TreeCloner(true);
        tree.traverse((HashTreeTraverser)cloner);
        return cloner.getClonedTree();
    }
}

