/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Properties;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.ScriptCacheKey;
import org.apache.jmeter.util.ScriptingBeanInfoSupport;
import org.apache.jmeter.util.ScriptingTestElement;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSR223TestElement
extends ScriptingTestElement
implements Serializable,
TestStateListener {
    private static final long serialVersionUID = 233L;
    private static final Logger logger = LoggerFactory.getLogger(JSR223TestElement.class);
    private static final Cache<ScriptCacheKey, CompiledScript> COMPILED_SCRIPT_CACHE = Caffeine.newBuilder().maximumSize((long)JMeterUtils.getPropDefault("jsr223.compiled_scripts_cache_size", 100)).build();
    private String cacheKey = "";
    private ScriptCacheKey scriptMd5;

    public static ScriptEngineManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    protected JSR223TestElement() {
    }

    protected ScriptEngine getScriptEngine() throws ScriptException {
        String lang = this.getScriptLanguageWithDefault();
        ScriptEngine scriptEngine = JSR223TestElement.getInstance().getEngineByName(lang);
        if (scriptEngine == null) {
            throw new ScriptException("Cannot find engine named: '" + lang + "', ensure you set language field in JSR223 Test Element: " + this.getName());
        }
        return scriptEngine;
    }

    private String getScriptLanguageWithDefault() {
        String lang = this.getScriptLanguage();
        if (StringUtils.isNotEmpty((CharSequence)lang)) {
            return lang;
        }
        return "groovy";
    }

    protected void populateBindings(Bindings bindings) {
        String label = this.getName();
        String fileName = this.getFilename();
        String scriptParameters = this.getParameters();
        Logger elementLogger = LoggerFactory.getLogger((String)(this.getClass().getName() + "." + this.getName()));
        bindings.put("log", (Object)elementLogger);
        bindings.put("Label", (Object)label);
        bindings.put("FileName", (Object)fileName);
        bindings.put("Parameters", (Object)scriptParameters);
        String[] args = JOrphanUtils.split((String)scriptParameters, (String)" ");
        bindings.put("args", (Object)args);
        JMeterContext jmctx = JMeterContextService.getContext();
        bindings.put("ctx", (Object)jmctx);
        JMeterVariables vars = jmctx.getVariables();
        bindings.put("vars", (Object)vars);
        Properties props = JMeterUtils.getJMeterProperties();
        bindings.put("props", (Object)props);
        bindings.put("OUT", (Object)System.out);
        Sampler sampler = jmctx.getCurrentSampler();
        bindings.put("sampler", (Object)sampler);
        SampleResult prev = jmctx.getPreviousResult();
        bindings.put("prev", (Object)prev);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object processFileOrScript(ScriptEngine scriptEngine, Bindings pBindings) throws IOException, ScriptException {
        Bindings bindings = pBindings;
        if (bindings == null) {
            bindings = scriptEngine.createBindings();
        }
        this.populateBindings(bindings);
        String filename = this.getFilename();
        File scriptFile = new File(filename);
        boolean supportsCompilable = scriptEngine instanceof Compilable && !"bsh.engine.BshScriptEngine".equals(scriptEngine.getClass().getName());
        try {
            if (StringUtils.isEmpty((CharSequence)filename)) {
                String script = this.getScript();
                if (StringUtils.isEmpty((CharSequence)script)) throw new ScriptException("Both script file and script text are empty for element:" + this.getName());
                if (!supportsCompilable) return scriptEngine.eval(script, bindings);
                if (ScriptingBeanInfoSupport.FALSE_AS_STRING.equals(this.cacheKey)) return scriptEngine.eval(script, bindings);
                this.computeScriptMD5(script);
                CompiledScript compiledScript = JSR223TestElement.getCompiledScript(this.scriptMd5, key -> {
                    try {
                        return ((Compilable)((Object)scriptEngine)).compile(script);
                    }
                    catch (ScriptException e) {
                        throw new ScriptCompilationInvocationTargetException(e);
                    }
                });
                return compiledScript.eval(bindings);
            }
            if (!scriptFile.isFile()) {
                throw new ScriptException("Script file '" + scriptFile.getAbsolutePath() + "' is not a file for element: " + this.getName());
            }
            if (!scriptFile.canRead()) {
                throw new ScriptException("Script file '" + scriptFile.getAbsolutePath() + "' is not readable for element:" + this.getName());
            }
            if (supportsCompilable) {
                ScriptCacheKey newCacheKey = ScriptCacheKey.ofFile(this.getScriptLanguage(), scriptFile.getAbsolutePath(), scriptFile.lastModified());
                CompiledScript compiledScript = JSR223TestElement.getCompiledScript(newCacheKey, key -> {
                    CompiledScript compiledScript;
                    block8: {
                        BufferedReader fileReader = Files.newBufferedReader(scriptFile.toPath());
                        try {
                            compiledScript = ((Compilable)((Object)scriptEngine)).compile(fileReader);
                            if (fileReader == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (fileReader != null) {
                                    try {
                                        fileReader.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException | ScriptException e) {
                                throw new ScriptCompilationInvocationTargetException(e);
                            }
                        }
                        fileReader.close();
                    }
                    return compiledScript;
                });
                return compiledScript.eval(bindings);
            }
            try (BufferedReader fileReader = Files.newBufferedReader(scriptFile.toPath());){
                Object object = scriptEngine.eval((Reader)fileReader, bindings);
                return object;
            }
        }
        catch (ScriptException ex) {
            Throwable rootCause = ex.getCause();
            if (!this.isStopCondition(rootCause)) throw ex;
            throw (RuntimeException)ex.getCause();
        }
    }

    private static <T extends ScriptCacheKey> CompiledScript getCompiledScript(T newCacheKey, Function<? super ScriptCacheKey, ? extends CompiledScript> compiler) throws IOException, ScriptException {
        try {
            CompiledScript compiledScript = (CompiledScript)COMPILED_SCRIPT_CACHE.get(newCacheKey, compiler);
            if (compiledScript == null) {
                throw new ScriptException("Script compilation returned null: " + newCacheKey);
            }
            return compiledScript;
        }
        catch (ScriptCompilationInvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                cause.addSuppressed(new IllegalStateException("Unable to compile script " + newCacheKey));
                throw (IOException)cause;
            }
            if (cause instanceof ScriptException) {
                cause.addSuppressed(new IllegalStateException("Unable to compile script " + newCacheKey));
                throw (ScriptException)cause;
            }
            throw e;
        }
    }

    public boolean compile() throws ScriptException, IOException {
        boolean supportsCompilable;
        String lang = this.getScriptLanguageWithDefault();
        ScriptEngine scriptEngine = JSR223TestElement.getInstance().getEngineByName(lang);
        boolean bl = supportsCompilable = scriptEngine instanceof Compilable && !"bsh.engine.BshScriptEngine".equals(scriptEngine.getClass().getName());
        if (!supportsCompilable) {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)this.getScript())) {
            try {
                ((Compilable)((Object)scriptEngine)).compile(this.getScript());
                return true;
            }
            catch (ScriptException e) {
                logger.error("Error compiling script for test element {}, error:{}", (Object)this.getName(), (Object)e.getMessage());
                return false;
            }
        }
        File scriptFile = new File(this.getFilename());
        try (BufferedReader fileReader = Files.newBufferedReader(scriptFile.toPath());){
            ((Compilable)((Object)scriptEngine)).compile(fileReader);
            boolean bl2 = true;
            return bl2;
        }
    }

    private void computeScriptMD5(String script) {
        if (this.scriptMd5 == null) {
            this.scriptMd5 = ScriptCacheKey.ofString(DigestUtils.md5Hex((String)script));
        }
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Override
    public void testStarted() {
    }

    @Override
    public void testStarted(String host) {
    }

    @Override
    public void testEnded() {
        this.testEnded("");
    }

    @Override
    public void testEnded(String host) {
        COMPILED_SCRIPT_CACHE.invalidateAll();
        this.scriptMd5 = null;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String s) {
        this.scriptLanguage = s;
    }

    private static class LazyHolder {
        public static final ScriptEngineManager INSTANCE = new ScriptEngineManager();

        private LazyHolder() {
        }
    }

    static class ScriptCompilationInvocationTargetException
    extends RuntimeException {
        public ScriptCompilationInvocationTargetException(Throwable cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

