/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.DefaultUIAwareIcon;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.IconSupplier;
import com.github.weisj.darklaf.icons.UIAwareIcon;
import javax.swing.Icon;

public class LazyUIAwareIcon
extends DefaultUIAwareIcon {
    private IconSupplier<Icon> lightSupplier;
    private IconSupplier<Icon> darkSupplier;

    public LazyUIAwareIcon(IconSupplier<Icon> lightSupplier, IconSupplier<Icon> darkSupplier) {
        this.lightSupplier = lightSupplier;
        this.darkSupplier = darkSupplier;
    }

    protected LazyUIAwareIcon(LazyUIAwareIcon dual) {
        super(dual);
        this.lightSupplier = dual.darkSupplier;
        this.darkSupplier = dual.lightSupplier;
    }

    @Override
    protected UIAwareIcon createDual() {
        return new LazyUIAwareIcon(this);
    }

    @Override
    protected Icon loadLightIcon() {
        Icon icon;
        if (this.lightSupplier != null) {
            icon = this.lightSupplier.getIcon();
            this.lightSupplier = null;
        } else {
            icon = EmptyIcon.create(0);
        }
        return icon;
    }

    @Override
    protected Icon loadDarkIcon() {
        Icon icon;
        if (this.darkSupplier != null) {
            icon = this.darkSupplier.getIcon();
            this.darkSupplier = null;
        } else {
            icon = EmptyIcon.create(0);
        }
        return icon;
    }
}

