/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Function;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.RecordTest;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;

public class Parts
extends SystemFunction
implements Callable {
    private static final Map<AtomicType, Map<String, ComponentDetails>> componentMap = new HashMap<AtomicType, Map<String, ComponentDetails>>();
    private static Map<AtomicType, RecordTest> resultTypeMap;

    @Override
    public ItemType getResultItemType(Expression[] args) {
        AtomicType argType = args[0].getStaticType().getPrimaryType().getAtomizedItemType().getPrimitiveItemType();
        if (argType == BuiltInAtomicType.ANY_ATOMIC) {
            return super.getResultItemType(args);
        }
        while (argType.getBaseType() != BuiltInAtomicType.ANY_ATOMIC) {
            argType = (AtomicType)argType.getBaseType();
        }
        RecordTest resultType = resultTypeMap.get(argType);
        if (resultType == null) {
            return super.getResultItemType(args);
        }
        return resultType;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        Map<String, ComponentDetails> details;
        DictionaryMap result = new DictionaryMap();
        AtomicValue subject = (AtomicValue)args[0].head();
        BuiltInAtomicType type = subject.getPrimitiveType();
        if (type.getBaseType() == BuiltInAtomicType.DURATION) {
            type = BuiltInAtomicType.DURATION;
        }
        if ((details = componentMap.get(type)) == null) {
            details = new HashMap<String, ComponentDetails>();
        }
        try {
            for (Map.Entry<String, ComponentDetails> component : details.entrySet()) {
                result.initialPut(component.getKey(), SequenceTool.toGroundedValue(component.getValue().supplier.apply(subject)));
            }
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
        result.initialPut("value", subject);
        return result;
    }

    private static void register(BuiltInAtomicType type, String fieldName, SequenceType componentType, Function<AtomicValue, SequenceIterator> supplier) {
        Map typeData = componentMap.computeIfAbsent(type, k -> new HashMap());
        ComponentDetails details = new ComponentDetails();
        details.componentType = componentType;
        details.supplier = supplier;
        typeData.put(fieldName, details);
    }

    static SequenceIterator oneInt(long x) {
        return SingletonIterator.makeIterator(Int64Value.makeIntegerValue(x));
    }

    static SequenceIterator oneDec(BigDecimal x) {
        return SingletonIterator.makeIterator(new BigDecimalValue(x));
    }

    static SequenceIterator timezone(CalendarValue a) {
        if (a.hasTimezone()) {
            try {
                return SingletonIterator.makeIterator(DayTimeDurationValue.fromMilliseconds(60000L * (long)a.getTimezoneInMinutes()));
            }
            catch (ValidationException e) {
                return EmptyIterator.ofAtomic();
            }
        }
        return EmptyIterator.ofAtomic();
    }

    private static void buildRecordTypes() {
        resultTypeMap = new HashMap<AtomicType, RecordTest>();
        for (Map.Entry<AtomicType, Map<String, ComponentDetails>> entry : componentMap.entrySet()) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<SequenceType> types = new ArrayList<SequenceType>();
            ArrayList<String> optionalFields = new ArrayList<String>();
            for (Map.Entry<String, ComponentDetails> details : entry.getValue().entrySet()) {
                names.add(details.getKey());
                types.add(details.getValue().componentType);
                if (!Cardinality.allowsZero(details.getValue().componentType.getCardinality())) continue;
                optionalFields.add(details.getKey());
            }
            names.add("value");
            types.add(SequenceType.makeSequenceType(entry.getKey(), 16384));
            resultTypeMap.put(entry.getKey(), new RecordTest(names, types, optionalFields, false));
        }
    }

    public static SequenceType getComponentType(BuiltInAtomicType type, String componentName) {
        Map<String, ComponentDetails> typeData;
        if (type == BuiltInAtomicType.DAY_TIME_DURATION || type == BuiltInAtomicType.YEAR_MONTH_DURATION) {
            type = BuiltInAtomicType.DURATION;
        }
        if ((typeData = componentMap.get(type)) == null) {
            return null;
        }
        ComponentDetails details = typeData.get(componentName);
        return details == null ? null : details.componentType;
    }

    public static SequenceIterator getComponentValue(AtomicValue value, String componentName) {
        Map<String, ComponentDetails> typeData;
        BuiltInAtomicType type = value.getPrimitiveType();
        if (type == BuiltInAtomicType.DAY_TIME_DURATION || type == BuiltInAtomicType.YEAR_MONTH_DURATION) {
            type = BuiltInAtomicType.DURATION;
        }
        if ((typeData = componentMap.get(type)) == null) {
            return EmptyIterator.ofAtomic();
        }
        Function<AtomicValue, SequenceIterator> supplier = typeData.get((Object)componentName).supplier;
        return supplier.apply(value);
    }

    public static DictionaryMap uriComponents(String arg) {
        DictionaryMap dict = new DictionaryMap();
        try {
            int port;
            String val;
            URI uri = new URI(arg);
            dict.initialPut("isValid", BooleanValue.TRUE);
            boolean absolute = uri.isAbsolute();
            dict.initialPut("isAbsolute", BooleanValue.get(absolute));
            dict.initialPut("isOpaque", BooleanValue.get(uri.isOpaque()));
            URI surrogateURI = absolute ? uri : Parts.getSurrogateURI(uri);
            String string = val = absolute ? uri.getAuthority() : null;
            if (val != null) {
                dict.initialPut("authority", new StringValue(val));
            }
            String string2 = val = absolute ? uri.getRawAuthority() : null;
            if (val != null) {
                dict.initialPut("rawAuthority", new StringValue(val));
            }
            String string3 = val = absolute ? uri.getUserInfo() : null;
            if (val != null) {
                dict.initialPut("userInfo", new StringValue(val));
            }
            String string4 = val = absolute ? uri.getRawUserInfo() : null;
            if (val != null) {
                dict.initialPut("rawUserInfo", new StringValue(val));
            }
            String string5 = val = absolute ? uri.getScheme() : null;
            if (val != null) {
                dict.initialPut("scheme", new StringValue(val));
            }
            String string6 = val = absolute ? uri.getHost() : null;
            if (val != null) {
                dict.initialPut("host", new StringValue(val));
            }
            if ((val = surrogateURI.getSchemeSpecificPart()) != null) {
                dict.initialPut("schemeSpecificPart", new StringValue(val));
            }
            if ((val = surrogateURI.getRawSchemeSpecificPart()) != null) {
                dict.initialPut("rawSchemeSpecificPart", new StringValue(val));
            }
            if (absolute && (port = uri.getPort()) >= 0) {
                dict.initialPut("port", new Int64Value(port));
            }
            if ((val = surrogateURI.getPath()) != null) {
                if (val.equals("/") && !arg.endsWith("/")) {
                    val = "";
                }
                if (!absolute && val.startsWith("/") && !arg.startsWith("/")) {
                    val = val.substring(1);
                }
                dict.initialPut("path", new StringValue(val));
            }
            if ((val = surrogateURI.getRawPath()) != null) {
                dict.initialPut("rawPath", new StringValue(val));
            }
            if ((val = surrogateURI.getRawQuery()) != null) {
                dict.initialPut("rawQuery", new StringValue(val));
            }
            if ((val = surrogateURI.getQuery()) != null) {
                dict.initialPut("query", new StringValue(val));
                DictionaryMap params = new DictionaryMap();
                StringTokenizer t = new StringTokenizer(val, ";&");
                while (t.hasMoreTokens()) {
                    String tok = t.nextToken();
                    int eq = tok.indexOf(61);
                    if (eq >= 0) {
                        String keyword = tok.substring(0, eq);
                        String value = tok.substring(eq + 1);
                        params.initialAppend(keyword, new StringValue(value));
                        continue;
                    }
                    params.initialAppend(tok, EmptySequence.getInstance());
                }
                dict.initialPut("queryParams", params);
            }
            if ((val = surrogateURI.getRawFragment()) != null) {
                dict.initialPut("rawFragment", new StringValue(val));
            }
            if ((val = surrogateURI.getFragment()) != null) {
                dict.initialPut("fragment", new StringValue(val));
            }
            if ((val = uri.toASCIIString()) != null) {
                dict.initialPut("asciiString", new StringValue(val));
            }
            return dict;
        }
        catch (URISyntaxException e) {
            dict.initialPut("isValid", BooleanValue.FALSE);
            dict.initialPut("error", new StringValue(e.getMessage()));
            return dict;
        }
    }

    private static URI getSurrogateURI(URI relative) {
        return relative;
    }

    static {
        Parts.register(BuiltInAtomicType.DATE_TIME, "year", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((DateTimeValue)a).getYear()));
        Parts.register(BuiltInAtomicType.DATE_TIME, "month", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((DateTimeValue)a).getMonth()));
        Parts.register(BuiltInAtomicType.DATE_TIME, "day", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((DateTimeValue)a).getDay()));
        Parts.register(BuiltInAtomicType.DATE_TIME, "hours", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((DateTimeValue)a).getHour()));
        Parts.register(BuiltInAtomicType.DATE_TIME, "minutes", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((DateTimeValue)a).getMinute()));
        Parts.register(BuiltInAtomicType.DATE_TIME, "seconds", SequenceType.SINGLE_INTEGER, a -> {
            BigDecimal d = BigDecimal.valueOf(((DateTimeValue)a).getNanosecond());
            d = d.divide(BigDecimalValue.BIG_DECIMAL_ONE_BILLION, 6, RoundingMode.HALF_UP);
            d = d.add(BigDecimal.valueOf(((DateTimeValue)a).getSecond()));
            return Parts.oneDec(d);
        });
        Parts.register(BuiltInAtomicType.DATE_TIME, "timezone", SequenceType.OPTIONAL_DAY_TIME_DURATION, a -> Parts.timezone((DateTimeValue)a));
        Parts.register(BuiltInAtomicType.DATE, "year", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((DateValue)a).getYear()));
        Parts.register(BuiltInAtomicType.DATE, "month", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((DateValue)a).getMonth()));
        Parts.register(BuiltInAtomicType.DATE, "day", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((DateValue)a).getDay()));
        Parts.register(BuiltInAtomicType.DATE, "timezone", SequenceType.OPTIONAL_DAY_TIME_DURATION, a -> Parts.timezone((DateValue)a));
        Parts.register(BuiltInAtomicType.TIME, "hours", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((TimeValue)a).getHour()));
        Parts.register(BuiltInAtomicType.TIME, "minutes", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((TimeValue)a).getMinute()));
        Parts.register(BuiltInAtomicType.TIME, "seconds", SequenceType.SINGLE_INTEGER, a -> {
            BigDecimal d = BigDecimal.valueOf(((TimeValue)a).getNanosecond());
            d = d.divide(BigDecimalValue.BIG_DECIMAL_ONE_BILLION, 6, RoundingMode.HALF_UP);
            d = d.add(BigDecimal.valueOf(((TimeValue)a).getSecond()));
            return Parts.oneDec(d);
        });
        Parts.register(BuiltInAtomicType.TIME, "timezone", SequenceType.OPTIONAL_DAY_TIME_DURATION, a -> Parts.timezone((TimeValue)a));
        Parts.register(BuiltInAtomicType.G_YEAR, "year", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((GDateValue)a).getYear()));
        Parts.register(BuiltInAtomicType.G_YEAR, "timezone", SequenceType.OPTIONAL_DAY_TIME_DURATION, a -> Parts.timezone((GDateValue)a));
        Parts.register(BuiltInAtomicType.G_YEAR_MONTH, "year", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((GDateValue)a).getYear()));
        Parts.register(BuiltInAtomicType.G_YEAR_MONTH, "month", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((GDateValue)a).getMonth()));
        Parts.register(BuiltInAtomicType.G_YEAR_MONTH, "timezone", SequenceType.OPTIONAL_DAY_TIME_DURATION, a -> Parts.timezone((GDateValue)a));
        Parts.register(BuiltInAtomicType.G_MONTH, "month", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((GDateValue)a).getMonth()));
        Parts.register(BuiltInAtomicType.G_MONTH, "timezone", SequenceType.OPTIONAL_DAY_TIME_DURATION, a -> Parts.timezone((GDateValue)a));
        Parts.register(BuiltInAtomicType.G_MONTH_DAY, "month", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((GDateValue)a).getMonth()));
        Parts.register(BuiltInAtomicType.G_MONTH_DAY, "day", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((GDateValue)a).getDay()));
        Parts.register(BuiltInAtomicType.G_MONTH_DAY, "timezone", SequenceType.OPTIONAL_DAY_TIME_DURATION, a -> Parts.timezone((GDateValue)a));
        Parts.register(BuiltInAtomicType.G_DAY, "day", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt(((GDateValue)a).getDay()));
        Parts.register(BuiltInAtomicType.G_DAY, "timezone", SequenceType.OPTIONAL_DAY_TIME_DURATION, a -> Parts.timezone((GDateValue)a));
        Parts.register(BuiltInAtomicType.DURATION, "years", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt((long)((DurationValue)a).getYears() * (long)((DurationValue)a).signum()));
        Parts.register(BuiltInAtomicType.DURATION, "months", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt((long)((DurationValue)a).getMonths() * (long)((DurationValue)a).signum()));
        Parts.register(BuiltInAtomicType.DURATION, "days", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt((long)((DurationValue)a).getDays() * (long)((DurationValue)a).signum()));
        Parts.register(BuiltInAtomicType.DURATION, "hours", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt((long)((DurationValue)a).getHours() * (long)((DurationValue)a).signum()));
        Parts.register(BuiltInAtomicType.DURATION, "minutes", SequenceType.SINGLE_INTEGER, a -> Parts.oneInt((long)((DurationValue)a).getMinutes() * (long)((DurationValue)a).signum()));
        Parts.register(BuiltInAtomicType.DURATION, "seconds", SequenceType.SINGLE_INTEGER, a -> SingletonIterator.makeIterator(((DurationValue)a).getComponent(AccessorFn.Component.SECONDS)));
        Parts.register(BuiltInAtomicType.HEX_BINARY, "octets", SequenceType.makeSequenceType(BuiltInAtomicType.UNSIGNED_BYTE, 57344), a -> {
            ArrayList<Int64Value> result = new ArrayList<Int64Value>();
            for (byte b : ((HexBinaryValue)a).getBinaryValue()) {
                result.add(new Int64Value(b & 0xFF, BuiltInAtomicType.UNSIGNED_BYTE));
            }
            return new ListIterator.Of(result);
        });
        Parts.register(BuiltInAtomicType.BASE64_BINARY, "octets", SequenceType.makeSequenceType(BuiltInAtomicType.UNSIGNED_BYTE, 57344), a -> {
            ArrayList<Int64Value> result = new ArrayList<Int64Value>();
            for (byte b : ((Base64BinaryValue)a).getBinaryValue()) {
                result.add(new Int64Value(b & 0xFF, BuiltInAtomicType.UNSIGNED_BYTE));
            }
            return new ListIterator.Of(result);
        });
        Parts.register(BuiltInAtomicType.QNAME, "prefix", SequenceType.OPTIONAL_STRING, a -> {
            String prefix = ((QNameValue)a).getStructuredQName().getPrefix();
            return prefix.isEmpty() ? EmptyIterator.ofAtomic() : SingletonIterator.makeIterator(new StringValue(prefix, (AtomicType)BuiltInAtomicType.NCNAME));
        });
        Parts.register(BuiltInAtomicType.QNAME, "namespace-uri", SequenceType.OPTIONAL_STRING, a -> {
            String uri = ((QNameValue)a).getStructuredQName().getURI();
            return uri.isEmpty() ? EmptyIterator.ofAtomic() : SingletonIterator.makeIterator(new StringValue(uri, (AtomicType)BuiltInAtomicType.ANY_URI));
        });
        Parts.register(BuiltInAtomicType.QNAME, "local-name", SequenceType.SINGLE_STRING, a -> {
            String local = ((QNameValue)a).getStructuredQName().getLocalPart();
            return SingletonIterator.makeIterator(new StringValue(local, (AtomicType)BuiltInAtomicType.NCNAME));
        });
        Parts.register(BuiltInAtomicType.ANY_URI, "scheme", SequenceType.OPTIONAL_STRING, a -> {
            DictionaryMap map = Parts.uriComponents(a.getStringValue());
            return SingletonIterator.makeIterator((StringValue)((MapItem)map).get(new StringValue("scheme")));
        });
        Parts.register(BuiltInAtomicType.ANY_URI, "authority", SequenceType.OPTIONAL_STRING, a -> {
            DictionaryMap map = Parts.uriComponents(a.getStringValue());
            return SingletonIterator.makeIterator((StringValue)((MapItem)map).get(new StringValue("authority")));
        });
        Parts.register(BuiltInAtomicType.ANY_URI, "path", SequenceType.OPTIONAL_STRING, a -> {
            DictionaryMap map = Parts.uriComponents(a.getStringValue());
            return SingletonIterator.makeIterator((StringValue)((MapItem)map).get(new StringValue("path")));
        });
        Parts.register(BuiltInAtomicType.ANY_URI, "query", SequenceType.OPTIONAL_STRING, a -> {
            DictionaryMap map = Parts.uriComponents(a.getStringValue());
            return SingletonIterator.makeIterator((StringValue)((MapItem)map).get(new StringValue("query")));
        });
        Parts.register(BuiltInAtomicType.ANY_URI, "fragment", SequenceType.OPTIONAL_STRING, a -> {
            DictionaryMap map = Parts.uriComponents(a.getStringValue());
            return SingletonIterator.makeIterator((StringValue)((MapItem)map).get(new StringValue("fragment")));
        });
        Parts.register(BuiltInAtomicType.ANY_URI, "query-parameters", MapType.SINGLE_MAP_ITEM, a -> {
            DictionaryMap map = Parts.uriComponents(a.getStringValue());
            return SingletonIterator.makeIterator((MapItem)((MapItem)map).get(new StringValue("queryParams")));
        });
        Parts.buildRecordTypes();
    }

    private static class ComponentDetails {
        SequenceType componentType;
        Function<AtomicValue, SequenceIterator> supplier;

        private ComponentDetails() {
        }
    }
}

