/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.builder.AxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/AxisUtil;", "", "()V", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "scaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "domain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "horizontal", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nAxisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1549#2:103\n1620#2,3:104\n1549#2:107\n1620#2,3:108\n1549#2:111\n1620#2,3:112\n1549#2:115\n1620#2,2:116\n1603#2,9:118\n1855#2:127\n1856#2:129\n1612#2,11:130\n766#2:141\n857#2:142\n1747#2,3:143\n858#2:146\n1549#2:147\n1620#2,3:148\n1#3:128\n*S KotlinDebug\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil\n*L\n82#1:103\n82#1:104,3\n29#1:107\n29#1:108,3\n45#1:111\n45#1:112,3\n60#1:115\n60#1:116,2\n60#1:118,9\n60#1:127\n60#1:129\n60#1:130,11\n63#1:141\n63#1:142\n64#1:143,3\n63#1:146\n74#1:147\n74#1:148,3\n60#1:128\n*E\n"})
public final class AxisUtil {
    @NotNull
    public static final AxisUtil INSTANCE = new AxisUtil();

    private AxisUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AxisComponent.BreaksData breaksData(@NotNull ScaleBreaks scaleBreaks, @NotNull CoordinateSystem coord, @NotNull DoubleRectangle domain, boolean flipAxis, boolean horizontal) {
        List list;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        List majorDomainBreak = scaleBreaks.getTransformedValues();
        if (majorDomainBreak.size() > 1) {
            void $this$mapTo$iv$iv;
            double step = ((Number)majorDomainBreak.get(1)).doubleValue() - ((Number)majorDomainBreak.get(0)).doubleValue();
            double start = ((Number)majorDomainBreak.get(0)).doubleValue() - step / 2.0;
            Iterable $this$map$iv = (Iterable)new IntRange(0, majorDomainBreak.size());
            boolean $i$f$map = false;
            iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(start + (double)it * step);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List minorDomainBreak = list;
        List<Double> majorClientBreaks = AxisUtil.breaksData$toClient$2(horizontal, domain, coord, flipAxis, majorDomainBreak);
        List<Double> minorClientBreaks = AxisUtil.breaksData$toClient$2(horizontal, domain, coord, flipAxis, minorDomainBreak);
        List<List<DoubleVector>> majorGrid = AxisUtil.breaksData$buildGrid(coord, domain, horizontal, flipAxis, majorDomainBreak);
        List<List<DoubleVector>> minorGrid = AxisUtil.breaksData$buildGrid(coord, domain, horizontal, flipAxis, minorDomainBreak);
        List list2 = CollectionsKt.filterNotNull((Iterable)majorClientBreaks);
        List list3 = CollectionsKt.filterNotNull((Iterable)minorClientBreaks);
        iterable = SeriesUtil.INSTANCE.pickAtIndices(scaleBreaks.getLabels(), SeriesUtil.INSTANCE.matchingIndices(majorClientBreaks, (Function1)breaksData.1.INSTANCE));
        return new AxisComponent.BreaksData(list2, (List<String>)iterable, list3, majorGrid, minorGrid);
    }

    private static final DoubleVector breaksData$toClient(CoordinateSystem $coord, boolean $flipAxis, DoubleVector v) {
        return SeriesUtil.INSTANCE.finiteOrNull($coord.toClient($flipAxis ? v.flip() : v));
    }

    private static final DoubleRectangle breaksData$toClient$0(CoordinateSystem $coord, boolean $flipAxis, DoubleRectangle v) {
        return $coord.toClient($flipAxis ? v.flip() : v);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Double> breaksData$toClient$2(boolean $horizontal, DoubleRectangle $domain, CoordinateSystem $coord, boolean $flipAxis, List<Double> breaks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = breaks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Double d;
            DoubleVector doubleVector;
            void breakValue;
            double d2 = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = $horizontal;
            if (bl2) {
                doubleVector = new DoubleVector((double)breakValue, $domain.yRange().getLowerEnd().doubleValue());
            } else if (!bl2) {
                doubleVector = new DoubleVector($domain.xRange().getLowerEnd().doubleValue(), (double)breakValue);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DoubleVector breakCoord = doubleVector;
            if (AxisUtil.breaksData$toClient($coord, $flipAxis, breakCoord) == null) {
                d = null;
            } else {
                double d3;
                DoubleVector breakClientCoord;
                boolean bl3 = $horizontal;
                if (bl3) {
                    d3 = breakClientCoord.getX();
                } else if (!bl3) {
                    d3 = breakClientCoord.getY();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                d = d3;
            }
            collection.add(d);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<DoubleVector>> breaksData$buildGrid(CoordinateSystem $coord, DoubleRectangle $domain, boolean $horizontal, boolean $flipAxis, List<Double> breaks) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = breaks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list;
            Object[] objectArray;
            void breakCoord;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = $horizontal;
            if (bl2) {
                objectArray = new DoubleVector[]{new DoubleVector((double)breakCoord, $domain.yRange().getLowerEnd().doubleValue()), new DoubleVector((double)breakCoord, $domain.yRange().getUpperEnd().doubleValue())};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else if (!bl2) {
                objectArray = new DoubleVector[]{new DoubleVector($domain.xRange().getLowerEnd().doubleValue(), (double)breakCoord), new DoubleVector($domain.xRange().getUpperEnd().doubleValue(), (double)breakCoord)};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(list);
        }
        List domainGrid = (List)destination$iv$iv;
        if ($coord.isLinear()) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = domainGrid;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void $this$mapNotNullTo$iv$iv;
                void line2;
                List list = (List)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl = false;
                Iterable $this$mapNotNull$iv = (Iterable)line2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    DoubleVector it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    DoubleVector p0 = (DoubleVector)element$iv$iv;
                    boolean bl4 = false;
                    if (AxisUtil.breaksData$toClient($coord, $flipAxis, p0) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                collection.add((List)destination$iv$iv3);
            }
            List clientGrid = (List)destination$iv$iv2;
            DoubleRectangle doubleRectangle = AxisUtil.breaksData$toClient$0($coord, $flipAxis, $domain);
            if (doubleRectangle == null || (doubleRectangle = doubleRectangle.inflate(-6.0)) == null) {
                throw new IllegalStateException("Cannot transform domain".toString());
            }
            DoubleRectangle gridArea = doubleRectangle;
            Iterable $this$filter$iv = clientGrid;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block14: {
                    List line3 = (List)element$iv$iv;
                    boolean bl6 = false;
                    Iterable $this$any$iv = line3;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DoubleVector it = (DoubleVector)element$iv;
                            boolean bl7 = false;
                            boolean bl8 = $horizontal ? gridArea.xRange().contains(it.getX()) : gridArea.yRange().contains(it.getY());
                            if (!bl8) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            return (List)destination$iv$iv4;
        }
        $this$map$iv = domainGrid;
        $i$f$map = false;
        Iterable $this$filter$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line4;
            List item$iv$iv2 = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AdaptiveResampler.Companion.resample((List)line4, 0.5, (Function1)new Function1<DoubleVector, DoubleVector>($coord, $flipAxis){
                final /* synthetic */ CoordinateSystem $coord;
                final /* synthetic */ boolean $flipAxis;
                {
                    this.$coord = $coord;
                    this.$flipAxis = $flipAxis;
                    super(1, Intrinsics.Kotlin.class, "toClient", "breaksData$toClient(Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;ZLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", 0);
                }

                @Nullable
                public final DoubleVector invoke(@NotNull DoubleVector p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return AxisUtil.access$breaksData$toClient(this.$coord, this.$flipAxis, p0);
                }
            }));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ DoubleVector access$breaksData$toClient(CoordinateSystem $coord, boolean $flipAxis, DoubleVector v) {
        return AxisUtil.breaksData$toClient($coord, $flipAxis, v);
    }
}

