/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.EFileIOErrorCode;
import com.helger.commons.io.file.EFileIOOperation;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileOperations {
    public static final boolean DEFAULT_EXCEPTION_ON_DELETE_ROOT = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileOperations.class);
    private static volatile boolean s_bExceptionOnDeleteRoot = true;
    private static final FileOperations INSTANCE = new FileOperations();

    private FileOperations() {
    }

    public static boolean isExceptionOnDeleteRoot() {
        return s_bExceptionOnDeleteRoot;
    }

    public static void setExceptionOnDeleteRoot(boolean bl) {
        s_bExceptionOnDeleteRoot = bl;
    }

    @Nonnull
    public static FileIOError createDir(@Nonnull File file) {
        ValueEnforcer.notNull(file, "Directory");
        if (file.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.CREATE_DIR, file);
        }
        File file2 = file.getParentFile();
        if (file2 != null && file2.exists() && !file2.canWrite()) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.CREATE_DIR, file);
        }
        try {
            EFileIOErrorCode eFileIOErrorCode = file.mkdir() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.CREATE_DIR, file);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getSecurityAsIOError(EFileIOOperation.CREATE_DIR, securityException);
        }
    }

    @Nonnull
    public static FileIOError createDirIfNotExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.createDir(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.TARGET_ALREADY_EXISTS)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.CREATE_DIR, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError createDirRecursive(@Nonnull File file) {
        ValueEnforcer.notNull(file, "Directory");
        if (file.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, file);
        }
        File file2 = file.getParentFile();
        if (file2 != null && file2.exists() && !file2.canWrite()) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, file);
        }
        try {
            EFileIOErrorCode eFileIOErrorCode = file.mkdirs() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, file);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getSecurityAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, securityException);
        }
    }

    @Nonnull
    public static FileIOError createDirRecursiveIfNotExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.createDirRecursive(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.TARGET_ALREADY_EXISTS)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.CREATE_DIR_RECURSIVE, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteDir(@Nonnull File file) {
        ValueEnforcer.notNull(file, "Directory");
        if (!FileHelper.existsDir(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        if (FileOperations.isExceptionOnDeleteRoot() && file.getAbsoluteFile().getParent() == null) {
            throw new IllegalArgumentException("Aren't we deleting the full drive: '" + file.getAbsolutePath() + "'");
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.canWrite()) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        try {
            Files.delete(file.toPath());
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        catch (NoSuchFileException noSuchFileException) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            return EFileIOErrorCode.OPERATION_FAILED.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        catch (IOException iOException) {
            return EFileIOErrorCode.IO_ERROR.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getSecurityAsIOError(EFileIOOperation.DELETE_DIR, securityException);
        }
    }

    @Nonnull
    public static FileIOError deleteDirIfExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.deleteDir(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_DIR, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteDirRecursive(@Nonnull File file) {
        ValueEnforcer.notNull(file, "Directory");
        if (!FileHelper.existsDir(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, file);
        }
        if (FileOperations.isExceptionOnDeleteRoot() && file.getAbsoluteFile().getParent() == null) {
            throw new IllegalArgumentException("Aren't we deleting the full drive: '" + file.getAbsolutePath() + "'");
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.canWrite()) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, file);
        }
        for (File file3 : FileHelper.getDirectoryContent(file)) {
            FileIOError fileIOError;
            if (file3.isDirectory()) {
                if (FilenameHelper.isSystemInternalDirectory(file3.getName()) || !(fileIOError = FileOperations.deleteDirRecursive(file3)).isFailure()) continue;
                return fileIOError;
            }
            if (file3.isFile()) {
                fileIOError = FileOperations.deleteFile(file3);
                if (!fileIOError.isFailure()) continue;
                return fileIOError;
            }
            return EFileIOErrorCode.OBJECT_CANNOT_BE_HANDLED.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, file3);
        }
        return FileOperations.deleteDir(file);
    }

    @Nonnull
    public static FileIOError deleteDirRecursiveIfExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.deleteDirRecursive(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_DIR_RECURSIVE, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError deleteFile(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        if (!FileHelper.existsFile(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.canWrite()) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        try {
            Files.delete(file.toPath());
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        catch (NoSuchFileException noSuchFileException) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            return EFileIOErrorCode.OPERATION_FAILED.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        catch (IOException iOException) {
            return EFileIOErrorCode.IO_ERROR.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getSecurityAsIOError(EFileIOOperation.DELETE_FILE, securityException);
        }
    }

    @Nonnull
    public static FileIOError deleteFileIfExisting(@Nonnull File file) {
        FileIOError fileIOError = FileOperations.deleteFile(file);
        if (fileIOError.getErrorCode().equals(EFileIOErrorCode.SOURCE_DOES_NOT_EXIST)) {
            return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.DELETE_FILE, file);
        }
        return fileIOError;
    }

    @Nonnull
    public static FileIOError renameFile(@Nonnull File file, @Nonnull File file2) {
        ValueEnforcer.notNull(file, "SourceFile");
        ValueEnforcer.notNull(file2, "TargetFile");
        if (!FileHelper.existsFile(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.RENAME_FILE, file);
        }
        if (EqualsHelper.equals(file, file2)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.RENAME_FILE, file);
        }
        if (file2.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.RENAME_FILE, file2);
        }
        File file3 = file.getParentFile();
        if (file3 != null && !file3.canWrite()) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_FILE, file);
        }
        File file4 = file2.getParentFile();
        if (file4 != null && file4.exists() && !file4.canWrite()) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_FILE, file2);
        }
        FileHelper.ensureParentDirectoryIsPresent(file2);
        try {
            EFileIOErrorCode eFileIOErrorCode = file.renameTo(file2) ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.RENAME_FILE, file, file2);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getSecurityAsIOError(EFileIOOperation.RENAME_FILE, securityException);
        }
    }

    @Nonnull
    public static FileIOError renameDir(@Nonnull File file, @Nonnull File file2) {
        ValueEnforcer.notNull(file, "SourceDirectory");
        ValueEnforcer.notNull(file2, "TargetDirectory");
        if (!FileHelper.existsDir(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.RENAME_DIR, file);
        }
        if (EqualsHelper.equals(file, file2)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.RENAME_DIR, file);
        }
        if (file2.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.RENAME_DIR, file2);
        }
        if (FileHelper.isParentDirectory(file, file2)) {
            return EFileIOErrorCode.TARGET_IS_CHILD_OF_SOURCE.getAsIOError(EFileIOOperation.RENAME_DIR, file, file2);
        }
        File file3 = file.getParentFile();
        if (file3 != null && !file3.canWrite()) {
            return EFileIOErrorCode.SOURCE_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_DIR, file);
        }
        File file4 = file2.getParentFile();
        if (file4 != null && file4.exists() && !file4.canWrite()) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.RENAME_DIR, file2);
        }
        FileHelper.ensureParentDirectoryIsPresent(file2);
        try {
            EFileIOErrorCode eFileIOErrorCode = file.renameTo(file2) ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
            return eFileIOErrorCode.getAsIOError(EFileIOOperation.RENAME_DIR, file, file2);
        }
        catch (SecurityException securityException) {
            return EFileIOErrorCode.getSecurityAsIOError(EFileIOOperation.RENAME_DIR, securityException);
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    private static ESuccess _copyFileViaChannel(@Nonnull File var0, @Nonnull File var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static ESuccess _copyFileViaStreams(@Nonnull File file, @Nonnull File file2) {
        FileInputStream fileInputStream = FileHelper.getInputStream(file);
        if (fileInputStream == null) {
            return ESuccess.FAILURE;
        }
        try {
            ESuccess eSuccess;
            FileOutputStream fileOutputStream = FileHelper.getOutputStream(file2, EAppend.TRUNCATE);
            if (fileOutputStream == null) {
                ESuccess eSuccess2 = ESuccess.FAILURE;
                return eSuccess2;
            }
            try {
                eSuccess = StreamHelper.copyInputStreamToOutputStream(fileInputStream, fileOutputStream);
            }
            catch (Throwable throwable) {
                StreamHelper.close(fileOutputStream);
                throw throwable;
            }
            StreamHelper.close(fileOutputStream);
            return eSuccess;
        }
        finally {
            StreamHelper.close(fileInputStream);
        }
    }

    @Nonnull
    public static FileIOError copyFile(@Nonnull File file, @Nonnull File file2) {
        ValueEnforcer.notNull(file, "SourceFile");
        ValueEnforcer.notNull(file2, "TargetFile");
        if (!FileHelper.existsFile(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.COPY_FILE, file);
        }
        if (EqualsHelper.equals(file, file2)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.COPY_FILE, file);
        }
        if (file2.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.COPY_FILE, file2);
        }
        if (!file.canRead()) {
            return EFileIOErrorCode.SOURCE_NOT_READABLE.getAsIOError(EFileIOOperation.COPY_FILE, file);
        }
        File file3 = file2.getParentFile();
        if (file3 != null && file3.exists() && !file3.canWrite()) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.COPY_FILE, file2);
        }
        FileHelper.ensureParentDirectoryIsPresent(file2);
        ESuccess eSuccess = FileOperations._copyFileViaStreams(file, file2);
        EFileIOErrorCode eFileIOErrorCode = eSuccess.isSuccess() ? EFileIOErrorCode.NO_ERROR : EFileIOErrorCode.OPERATION_FAILED;
        return eFileIOErrorCode.getAsIOError(EFileIOOperation.COPY_FILE, file, file2);
    }

    @Nonnull
    public static FileIOError copyDirRecursive(@Nonnull File file, @Nonnull File file2) {
        ValueEnforcer.notNull(file, "SourceDirectory");
        ValueEnforcer.notNull(file2, "TargetDirectory");
        if (!FileHelper.existsDir(file)) {
            return EFileIOErrorCode.SOURCE_DOES_NOT_EXIST.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file);
        }
        if (EqualsHelper.equals(file, file2)) {
            return EFileIOErrorCode.SOURCE_EQUALS_TARGET.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file);
        }
        if (FileHelper.isParentDirectory(file, file2)) {
            return EFileIOErrorCode.TARGET_IS_CHILD_OF_SOURCE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file, file2);
        }
        if (file2.exists()) {
            return EFileIOErrorCode.TARGET_ALREADY_EXISTS.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file2);
        }
        if (!file.canRead()) {
            return EFileIOErrorCode.SOURCE_NOT_READABLE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file);
        }
        File file3 = file2.getParentFile();
        if (file3 != null && file3.exists() && !file3.canWrite()) {
            return EFileIOErrorCode.TARGET_PARENT_NOT_WRITABLE.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file2);
        }
        FileIOError fileIOError = FileOperations.createDirRecursive(file2);
        if (fileIOError.isFailure()) {
            return fileIOError;
        }
        for (File file4 : FileHelper.getDirectoryContent(file)) {
            if (file4.isDirectory()) {
                if (FilenameHelper.isSystemInternalDirectory(file4.getName()) || !(fileIOError = FileOperations.copyDirRecursive(file4, new File(file2, file4.getName()))).isFailure()) continue;
                return fileIOError;
            }
            if (file4.isFile()) {
                fileIOError = FileOperations.copyFile(file4, new File(file2, file4.getName()));
                if (!fileIOError.isFailure()) continue;
                return fileIOError;
            }
            return EFileIOErrorCode.OBJECT_CANNOT_BE_HANDLED.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file4);
        }
        return EFileIOErrorCode.NO_ERROR.getAsIOError(EFileIOOperation.COPY_DIR_RECURSIVE, file, file2);
    }
}

