/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mutable;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mutable.AbstractMutableInteger;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MutableByte
extends AbstractMutableInteger<MutableByte> {
    private byte m_nValue;

    public MutableByte(int n) {
        this((byte)n);
    }

    public MutableByte(@Nonnull Number number) {
        this(number.byteValue());
    }

    public MutableByte(byte by) {
        this.m_nValue = by;
    }

    @Override
    public byte byteValue() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public int intValue() {
        return this.m_nValue;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int n) {
        this.m_nValue = (byte)(this.m_nValue + n);
        this.onAfterChange();
        return this.m_nValue;
    }

    public int inc(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.byteValue());
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int n) {
        return this.inc(-n);
    }

    public int dec(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.byteValue());
    }

    @Nonnull
    public EChange set(int n) {
        return this.set((byte)n);
    }

    @Nonnull
    public EChange set(byte by) {
        if (this.m_nValue == by) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = by;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange set(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.byteValue());
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0;
    }

    @Override
    public boolean isLT0() {
        return this.m_nValue < 0;
    }

    @Override
    public boolean isLE0() {
        return this.m_nValue <= 0;
    }

    @Override
    public boolean isGT0() {
        return this.m_nValue > 0;
    }

    @Override
    public boolean isGE0() {
        return this.m_nValue >= 0;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2 == 0;
    }

    public byte getAndInc() {
        byte by = this.byteValue();
        this.inc();
        return by;
    }

    public byte incAndGet() {
        this.inc();
        return this.byteValue();
    }

    @Override
    public int compareTo(@Nonnull MutableByte mutableByte) {
        return CompareHelper.compare(this.m_nValue, mutableByte.m_nValue);
    }

    @Override
    @Nonnull
    public MutableByte getClone() {
        return new MutableByte(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableByte mutableByte = (MutableByte)object;
        return this.m_nValue == mutableByte.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).getToString();
    }
}

