/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text.popup;

import com.github.weisj.darklaf.ui.text.popup.CopyMenuItem;
import com.github.weisj.darklaf.ui.text.popup.CutMenuItem;
import com.github.weisj.darklaf.ui.text.popup.DeleteMenuItem;
import com.github.weisj.darklaf.ui.text.popup.PasteMenuItem;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarkTextPopupMenu
extends JPopupMenu
implements UIResource {
    private final JMenuItem cut;
    private final JMenuItem copy;
    private final JMenuItem paste;
    private final JMenuItem delete;

    public DarkTextPopupMenu(JTextComponent editor) {
        Locale l = editor.getLocale();
        this.cut = new CutMenuItem(UIManager.getString((Object)"Actions.cut", l), editor);
        this.copy = new CopyMenuItem(UIManager.getString((Object)"Actions.copy", l), editor);
        this.paste = new PasteMenuItem(UIManager.getString((Object)"Actions.paste", l), editor);
        this.delete = new DeleteMenuItem(UIManager.getString((Object)"Actions.delete", l), editor);
        this.add(this.cut);
        this.add(this.copy);
        this.add(this.paste);
        this.add(this.delete);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this.updateMenuItems();
        if (!(this.cut.isEnabled() || this.copy.isEnabled() || this.paste.isEnabled() || this.delete.isEnabled())) {
            return;
        }
        super.show(invoker, x, y);
    }

    protected void updateMenuItems() {
        this.updateMenuItem(this.cut);
        this.updateMenuItem(this.copy);
        this.updateMenuItem(this.paste);
        this.updateMenuItem(this.delete);
    }

    protected void updateMenuItem(JMenuItem item) {
        item.setEnabled(item.isEnabled());
    }
}

