/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton;

import java.awt.AWTKeyStroke;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;

public class DarkToggleButtonKeyHandler
implements KeyListener {
    @Override
    public void keyPressed(KeyEvent e) {
        AWTKeyStroke stroke = AWTKeyStroke.getAWTKeyStrokeForEvent(e);
        if (stroke != null && e.getSource() instanceof AbstractButton) {
            AbstractButton comp;
            ButtonGroup group;
            AbstractButton source = (AbstractButton)e.getSource();
            ButtonModel model = source.getModel();
            if (!(model instanceof DefaultButtonModel)) {
                model = null;
            }
            DefaultButtonModel bm = model != null ? (DefaultButtonModel)model : null;
            ButtonGroup buttonGroup = group = bm != null ? bm.getGroup() : null;
            if (group == null || group.getButtonCount() == 0) {
                group = null;
            }
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = comp = group != null ? (Container)group.getElements().nextElement() : source;
            if (this.isFocusTraversalKey(source, 0, stroke)) {
                fm.focusNextComponent(comp);
            } else if (this.isFocusTraversalKey(source, 1, stroke)) {
                fm.focusPreviousComponent(comp);
            } else if (this.isFocusTraversalKey(source, 2, stroke)) {
                fm.upFocusCycle(comp);
            } else if (this.isFocusTraversalKey(source, 3, stroke)) {
                fm.downFocusCycle(comp);
            }
        }
    }

    private boolean isFocusTraversalKey(JComponent c, int id, AWTKeyStroke stroke) {
        Set<AWTKeyStroke> keys = c.getFocusTraversalKeys(id);
        return keys != null && keys.contains(stroke);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

