/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.log.DarkLogHandler;
import com.github.weisj.darklaf.log.LogFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogUtil {
    private static final Logger PARENT = Logger.getLogger("com.github.weisj.darklaf");
    private static final Handler LOG_HANDLER = new DarkLogHandler();

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        logger.setUseParentHandlers(true);
        return logger;
    }

    public static Logger getDetachedLogger(Class<?> clazz) {
        Logger logger = LogUtil.getLogger(clazz);
        logger.setParent(PARENT);
        logger.setUseParentHandlers(false);
        logger.addHandler(LOG_HANDLER);
        return logger;
    }

    public static void setLevel(Level level) {
        PARENT.setLevel(level);
        LOG_HANDLER.setLevel(level);
    }

    public static Level getLevel() {
        return PARENT.getLevel();
    }

    public static <T> T log(T obj) {
        PARENT.info(String.valueOf(obj));
        return obj;
    }

    static {
        LOG_HANDLER.setFormatter(new LogFormatter());
        PARENT.setUseParentHandlers(false);
        PARENT.addHandler(LOG_HANDLER);
    }
}

