/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.node.Node;

public class NegateNode<T>
extends Node<T> {
    private final Expression<T> negated;

    public NegateNode(Adapter<T> runtime, Expression<T> negated) {
        super(runtime);
        this.negated = negated;
    }

    @Override
    public T search(T input) {
        return this.runtime.createBoolean(!this.runtime.isTruthy(this.negated.search(input)));
    }

    @Override
    protected boolean internalEquals(Object o) {
        NegateNode other = (NegateNode)o;
        return this.negated.equals(other.negated);
    }

    @Override
    protected String internalToString() {
        return this.negated.toString();
    }

    @Override
    protected int internalHashCode() {
        return 17 + 31 * this.negated.hashCode();
    }
}

