/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

class FocusActions {
    static final AbstractAction TRANSFER_FOCUS = new TransferFocusAction();
    static final AbstractAction TRANSFER_FOCUS_BACKWARD = new TransferFocusBackwardAction();

    FocusActions() {
    }

    static void bind(JComponent c, KeyStroke focusForward, KeyStroke focusBackward) {
        Object transferFocusName = TRANSFER_FOCUS.getValue("Name");
        Object transferFocusBackward = TRANSFER_FOCUS_BACKWARD.getValue("Name");
        InputMap inputMap = c.getInputMap();
        ActionMap actionMap = c.getActionMap();
        if (focusForward != null) {
            inputMap.put(focusForward, transferFocusName);
            actionMap.put(transferFocusName, TRANSFER_FOCUS);
        }
        if (focusBackward != null) {
            inputMap.put(focusBackward, transferFocusBackward);
            actionMap.put(transferFocusBackward, TRANSFER_FOCUS_BACKWARD);
        }
    }

    private static class TransferFocusAction
    extends AbstractAction {
        public TransferFocusAction() {
            super("Transfer focus forward");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component comp = (Component)e.getSource();
            if (comp != null) {
                comp.transferFocus();
            }
        }
    }

    private static class TransferFocusBackwardAction
    extends AbstractAction {
        public TransferFocusBackwardAction() {
            super("Transfer focus backward");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component comp = (Component)e.getSource();
            if (comp != null) {
                comp.transferFocusBackward();
            }
        }
    }
}

