/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class ShellBasedUnixGroupsMapping
extends Configured
implements GroupMappingServiceProvider {
    @VisibleForTesting
    protected static final Logger LOG = LoggerFactory.getLogger(ShellBasedUnixGroupsMapping.class);
    private long timeout = 0L;
    private static final Set<String> EMPTY_GROUPS_SET = Collections.emptySet();

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            this.timeout = conf.getTimeDuration("hadoop.security.groups.shell.command.timeout", 0L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public List<String> getGroups(String userName) throws IOException {
        return new ArrayList<String>(this.getUnixGroups(userName));
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    @Override
    public Set<String> getGroupsSet(String userName) throws IOException {
        return this.getUnixGroups(userName);
    }

    protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
        return new Shell.ShellCommandExecutor(this.getGroupsForUserCommand(userName), null, null, this.timeout);
    }

    protected String[] getGroupsForUserCommand(String userName) {
        return Shell.getGroupsForUserCommand(userName);
    }

    protected Shell.ShellCommandExecutor createGroupIDExecutor(String userName) {
        return new Shell.ShellCommandExecutor(this.getGroupsIDForUserCommand(userName), null, null, this.timeout);
    }

    protected String[] getGroupsIDForUserCommand(String userName) {
        return Shell.getGroupsIDForUserCommand(userName);
    }

    private boolean handleExecutorTimeout(Shell.ShellCommandExecutor executor, String user) {
        if (executor.isTimedOut()) {
            LOG.warn("Unable to return groups for user '{}' as shell group lookup command '{}' ran longer than the configured timeout limit of {} seconds.", new Object[]{user, Joiner.on((char)' ').join((Object[])executor.getExecString()), this.timeout});
            return true;
        }
        return false;
    }

    private Set<String> getUnixGroups(String user) throws IOException {
        Set<String> groups;
        Shell.ShellCommandExecutor executor = this.createGroupExecutor(user);
        try {
            executor.execute();
            groups = this.resolveFullGroupNames(executor.getOutput());
        }
        catch (Shell.ExitCodeException e) {
            if (this.handleExecutorTimeout(executor, user)) {
                return EMPTY_GROUPS_SET;
            }
            try {
                groups = this.resolvePartialGroupNames(user, e.getMessage(), executor.getOutput());
            }
            catch (PartialGroupNameException pge) {
                LOG.debug("unable to return groups for user {}", (Object)user, (Object)pge);
                return EMPTY_GROUPS_SET;
            }
        }
        catch (IOException ioe) {
            if (this.handleExecutorTimeout(executor, user)) {
                return EMPTY_GROUPS_SET;
            }
            throw ioe;
        }
        return groups;
    }

    private Set<String> parsePartialGroupNames(String groupNames, String groupIDs) throws PartialGroupNameException {
        StringTokenizer nameTokenizer = new StringTokenizer(groupNames, Shell.TOKEN_SEPARATOR_REGEX);
        StringTokenizer idTokenizer = new StringTokenizer(groupIDs, Shell.TOKEN_SEPARATOR_REGEX);
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        while (nameTokenizer.hasMoreTokens()) {
            if (!idTokenizer.hasMoreTokens()) {
                throw new PartialGroupNameException("Number of group names and ids do not match. group name =" + groupNames + ", group id = " + groupIDs);
            }
            String groupName = nameTokenizer.nextToken();
            String groupID = idTokenizer.nextToken();
            if (StringUtils.isNumeric((CharSequence)groupName) && groupName.equals(groupID)) continue;
            groups.add(groupName);
        }
        return groups;
    }

    private Set<String> resolvePartialGroupNames(String userName, String errMessage, String groupNames) throws PartialGroupNameException {
        if (Shell.WINDOWS) {
            throw new PartialGroupNameException("Does not support partial group name resolution on Windows. " + errMessage);
        }
        if (groupNames.isEmpty()) {
            throw new PartialGroupNameException("The user name '" + userName + "' is not found. " + errMessage);
        }
        LOG.warn("Some group names for '{}' are not resolvable. {}", (Object)userName, (Object)errMessage);
        Shell.ShellCommandExecutor partialResolver = this.createGroupIDExecutor(userName);
        try {
            partialResolver.execute();
            return this.parsePartialGroupNames(groupNames, partialResolver.getOutput());
        }
        catch (Shell.ExitCodeException ece) {
            throw new PartialGroupNameException("failed to get group id list for user '" + userName + "'", ece);
        }
        catch (IOException ioe) {
            String message = "Can't execute the shell command to get the list of group id for user '" + userName + "'";
            if (partialResolver.isTimedOut()) {
                message = message + " because of the command taking longer than the configured timeout: " + this.timeout + " seconds";
            }
            throw new PartialGroupNameException(message, ioe);
        }
    }

    @VisibleForTesting
    protected Set<String> resolveFullGroupNames(String groupNames) {
        StringTokenizer tokenizer = new StringTokenizer(groupNames, Shell.TOKEN_SEPARATOR_REGEX);
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }

    private static class PartialGroupNameException
    extends IOException {
        public PartialGroupNameException(String message) {
            super(message);
        }

        public PartialGroupNameException(String message, Throwable err) {
            super(message, err);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("PartialGroupNameException ");
            sb.append(super.getMessage());
            return sb.toString();
        }
    }
}

