/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.async.AsyncSearchOperation;
import org.ldaptive.async.handler.AsyncRequestHandler;
import org.ldaptive.async.handler.ExceptionHandler;
import org.ldaptive.control.SyncRequestControl;
import org.ldaptive.control.util.CookieManager;
import org.ldaptive.control.util.DefaultCookieManager;
import org.ldaptive.control.util.SyncReplItem;
import org.ldaptive.extended.CancelOperation;
import org.ldaptive.extended.CancelRequest;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.handler.IntermediateResponseHandler;
import org.ldaptive.handler.OperationResponseHandler;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.intermediate.IntermediateResponse;
import org.ldaptive.intermediate.SyncInfoMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;
    private final boolean refreshAndPersist;
    private final CookieManager cookieManager;

    public SyncReplClient(Connection conn, boolean persist) {
        this.connection = conn;
        this.refreshAndPersist = persist;
        this.cookieManager = null;
    }

    @Deprecated
    public SyncReplClient(Connection conn, boolean persist, byte[] cookie) {
        this.connection = conn;
        this.refreshAndPersist = persist;
        this.cookieManager = new DefaultCookieManager(cookie);
    }

    public BlockingQueue<SyncReplItem> execute(SearchRequest request) throws LdapException {
        CookieManager manager = this.cookieManager != null ? this.cookieManager : new DefaultCookieManager();
        return this.execute(request, manager, Integer.MAX_VALUE);
    }

    public BlockingQueue<SyncReplItem> execute(SearchRequest request, CookieManager manager) throws LdapException {
        return this.execute(request, manager, Integer.MAX_VALUE);
    }

    public BlockingQueue<SyncReplItem> execute(SearchRequest request, final CookieManager manager, int capacity) throws LdapException {
        final LinkedBlockingQueue<SyncReplItem> queue = new LinkedBlockingQueue<SyncReplItem>(capacity);
        final AsyncSearchOperation search = new AsyncSearchOperation(this.connection);
        search.setOperationResponseHandlers(new OperationResponseHandler<SearchRequest, SearchResult>(){

            @Override
            public HandlerResult<Response<SearchResult>> handle(Connection conn, SearchRequest request, Response<SearchResult> response) throws LdapException {
                try {
                    byte[] cookie;
                    SyncReplClient.this.logger.debug("received {}", response);
                    search.shutdown();
                    SyncReplItem item = new SyncReplItem(new SyncReplItem.Response(response));
                    if (item.getResponse().getSyncDoneControl() != null && (cookie = item.getResponse().getSyncDoneControl().getCookie()) != null) {
                        manager.writeCookie(cookie);
                    }
                    queue.put(item);
                }
                catch (Exception e) {
                    SyncReplClient.this.logger.warn("Unable to enqueue response {}", response);
                }
                return new HandlerResult<Response<SearchResult>>(response);
            }
        });
        search.setAsyncRequestHandlers(new AsyncRequestHandler(){

            @Override
            public HandlerResult<AsyncRequest> handle(Connection conn, Request request, AsyncRequest asyncRequest) throws LdapException {
                try {
                    SyncReplClient.this.logger.debug("received {}", (Object)asyncRequest);
                    queue.put(new SyncReplItem(asyncRequest));
                }
                catch (Exception e) {
                    SyncReplClient.this.logger.warn("Unable to enqueue async request {}", (Object)asyncRequest);
                }
                return new HandlerResult<Object>(null);
            }
        });
        search.setExceptionHandler(new ExceptionHandler(){

            @Override
            public HandlerResult<Exception> handle(Connection conn, Request request, Exception exception) {
                try {
                    SyncReplClient.this.logger.debug("received exception:", (Throwable)exception);
                    search.shutdown();
                    queue.put(new SyncReplItem(exception));
                }
                catch (Exception e) {
                    SyncReplClient.this.logger.warn("Unable to enqueue exception:", (Throwable)exception);
                }
                return new HandlerResult<Object>(null);
            }
        });
        request.setControls(new SyncRequestControl(this.refreshAndPersist ? SyncRequestControl.Mode.REFRESH_AND_PERSIST : SyncRequestControl.Mode.REFRESH_ONLY, manager.readCookie(), true));
        request.setSearchEntryHandlers(new SearchEntryHandler(){

            @Override
            public HandlerResult<SearchEntry> handle(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
                try {
                    byte[] cookie;
                    SyncReplClient.this.logger.debug("received {}", (Object)entry);
                    SyncReplItem item = new SyncReplItem(new SyncReplItem.Entry(entry));
                    if (item.getEntry().getSyncStateControl() != null && (cookie = item.getEntry().getSyncStateControl().getCookie()) != null) {
                        manager.writeCookie(cookie);
                    }
                    queue.put(item);
                }
                catch (Exception e) {
                    SyncReplClient.this.logger.warn("Unable to enqueue entry {}", (Object)entry);
                }
                return new HandlerResult<Object>(null);
            }

            @Override
            public void initializeRequest(SearchRequest request) {
            }
        });
        request.setIntermediateResponseHandlers(new IntermediateResponseHandler(){

            @Override
            public HandlerResult<IntermediateResponse> handle(Connection conn, Request request, IntermediateResponse response) throws LdapException {
                if ("1.3.6.1.4.1.4203.1.9.1.4".equals(response.getOID())) {
                    try {
                        SyncReplClient.this.logger.debug("received {}", (Object)response);
                        SyncInfoMessage message = (SyncInfoMessage)response;
                        if (message.getCookie() != null) {
                            manager.writeCookie(message.getCookie());
                        }
                        queue.put(new SyncReplItem(message));
                    }
                    catch (Exception e) {
                        SyncReplClient.this.logger.warn("Unable to enqueue intermediate response {}", (Object)response);
                    }
                }
                return new HandlerResult<Object>(null);
            }
        });
        search.execute(request);
        return queue;
    }

    public Response<Void> cancel(int messageId) throws LdapException {
        CancelOperation cancel = new CancelOperation(this.connection);
        return cancel.execute(new CancelRequest(messageId));
    }
}

