/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Arguments used to configure a cluster for Kerberos.")
public class ApiConfigureForKerberosArguments {
    @SerializedName(value="datanodeTransceiverPort")
    private BigDecimal datanodeTransceiverPort = null;
    @SerializedName(value="datanodeWebPort")
    private BigDecimal datanodeWebPort = null;

    public ApiConfigureForKerberosArguments datanodeTransceiverPort(BigDecimal datanodeTransceiverPort) {
        this.datanodeTransceiverPort = datanodeTransceiverPort;
        return this;
    }

    @Schema(description="The HDFS DataNode transceiver port to use. This will be applied to all DataNode role configuration groups. If not specified, this will default to 1004.")
    public BigDecimal getDatanodeTransceiverPort() {
        return this.datanodeTransceiverPort;
    }

    public void setDatanodeTransceiverPort(BigDecimal datanodeTransceiverPort) {
        this.datanodeTransceiverPort = datanodeTransceiverPort;
    }

    public ApiConfigureForKerberosArguments datanodeWebPort(BigDecimal datanodeWebPort) {
        this.datanodeWebPort = datanodeWebPort;
        return this;
    }

    @Schema(description="The HDFS DataNode web port to use.  This will be applied to all DataNode role configuration groups. If not specified, this will default to 1006.")
    public BigDecimal getDatanodeWebPort() {
        return this.datanodeWebPort;
    }

    public void setDatanodeWebPort(BigDecimal datanodeWebPort) {
        this.datanodeWebPort = datanodeWebPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiConfigureForKerberosArguments apiConfigureForKerberosArguments = (ApiConfigureForKerberosArguments)o;
        return Objects.equals(this.datanodeTransceiverPort, apiConfigureForKerberosArguments.datanodeTransceiverPort) && Objects.equals(this.datanodeWebPort, apiConfigureForKerberosArguments.datanodeWebPort);
    }

    public int hashCode() {
        return Objects.hash(this.datanodeTransceiverPort, this.datanodeWebPort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiConfigureForKerberosArguments {\n");
        sb.append("    datanodeTransceiverPort: ").append(this.toIndentedString(this.datanodeTransceiverPort)).append("\n");
        sb.append("    datanodeWebPort: ").append(this.toIndentedString(this.datanodeWebPort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

