/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ctl;

import java.io.Serializable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.ctl.ServiceControlAction$;
import org.apache.kyuubi.ctl.ServiceControlCli$;
import org.apache.kyuubi.ctl.ServiceControlCliArguments;
import org.apache.kyuubi.ctl.ServiceControlCliArguments$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.ServiceDiscovery$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.ha.client.ZooKeeperClientProvider$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\t\u0013\u0001QQ\u0002\"B\u0013\u0001\t\u00039\u0003b\u0002\u0016\u0001\u0001\u0004%Ia\u000b\u0005\b_\u0001\u0001\r\u0011\"\u00031\u0011\u00191\u0004\u0001)Q\u0005Y!)q\u0007\u0001C\u0001q!)\u0011\n\u0001C\t\u0015\")q\n\u0001C\u0005!\")!\u000b\u0001C\u0005'\")q\u000b\u0001C\u00051\"9\u00111\u0001\u0001\u0005\n\u0005\u0015qaBA\u0005%!\u0005\u00111\u0002\u0004\u0007#IA\t!!\u0004\t\r\u0015bA\u0011AA\u000b\u0011\u001d\t9\u0002\u0004C!\u00033A\u0001\"!\b\r\t\u0003\u0011\u0012q\u0004\u0005\t\u0003GaA\u0011\u0001\n\u0002&\t\t2+\u001a:wS\u000e,7i\u001c8ue>d7\t\\5\u000b\u0005M!\u0012aA2uY*\u0011QCF\u0001\u0007Wf,XOY5\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#G5\tA#\u0003\u0002%)\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003I\tqA^3sE>\u001cX-F\u0001-!\taR&\u0003\u0002/;\t9!i\\8mK\u0006t\u0017a\u0003<fe\n|7/Z0%KF$\"!\r\u001b\u0011\u0005q\u0011\u0014BA\u001a\u001e\u0005\u0011)f.\u001b;\t\u000fU\u001a\u0011\u0011!a\u0001Y\u0005\u0019\u0001\u0010J\u0019\u0002\u0011Y,'OY8tK\u0002\n\u0001\u0002Z8BGRLwN\u001c\u000b\u0003ceBQAO\u0003A\u0002m\nA!\u0019:hgB\u0019A\u0004\u0010 \n\u0005uj\"!B!se\u0006L\bCA G\u001d\t\u0001E\t\u0005\u0002B;5\t!I\u0003\u0002DM\u00051AH]8pizJ!!R\u000f\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bv\ta\u0002]1sg\u0016\f%oZ;nK:$8\u000f\u0006\u0002L\u001dB\u0011\u0011\u0006T\u0005\u0003\u001bJ\u0011!dU3sm&\u001cWmQ8oiJ|Gn\u00117j\u0003J<W/\\3oiNDQA\u000f\u0004A\u0002m\naa\u0019:fCR,GCA\u0019R\u0011\u0015Qt\u00011\u0001L\u0003\u0011a\u0017n\u001d;\u0015\u0007E\"V\u000bC\u0003;\u0011\u0001\u00071\nC\u0003W\u0011\u0001\u0007A&\u0001\bgS2$XM\u001d%pgR\u0004vN\u001d;\u0002\u001f\u001d,GoU3sm&\u001cWMT8eKN$B!\u00176umB\u0019!l\u00182\u000f\u0005mkfBA!]\u0013\u0005q\u0012B\u00010\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0007M+\u0017O\u0003\u0002_;A\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0007G2LWM\u001c;\u000b\u0005\u001d$\u0012A\u00015b\u0013\tIGMA\bTKJ4\u0018nY3O_\u0012,\u0017J\u001c4p\u0011\u0015Y\u0017\u00021\u0001m\u0003!Q8n\u00117jK:$\bCA7s\u001b\u0005q'BA8q\u0003%1'/Y7fo>\u00148N\u0003\u0002r-\u000591-\u001e:bi>\u0014\u0018BA:o\u0005A\u0019UO]1u_J4%/Y7fo>\u00148\u000eC\u0003v\u0013\u0001\u0007a(A\u0005{]>$WMU8pi\")q/\u0003a\u0001q\u0006Y\u0001n\\:u!>\u0014Ho\u00149u!\ra\u0012p_\u0005\u0003uv\u0011aa\u00149uS>t\u0007\u0003\u0002\u000f}}yL!!`\u000f\u0003\rQ+\b\u000f\\33!\tar0C\u0002\u0002\u0002u\u00111!\u00138u\u0003\u0019!W\r\\3uKR\u0019\u0011'a\u0002\t\u000biR\u0001\u0019A&\u0002#M+'O^5dK\u000e{g\u000e\u001e:pY\u000ec\u0017\u000e\u0005\u0002*\u0019M)AbGA\bCA\u0019\u0011&!\u0005\n\u0007\u0005M!C\u0001\tD_6l\u0017M\u001c3MS:,W\u000b^5mgR\u0011\u00111B\u0001\u0005[\u0006Lg\u000eF\u00022\u00037AQA\u000f\bA\u0002m\nabZ3u5.t\u0015-\\3ta\u0006\u001cW\rF\u0002?\u0003CAQAO\bA\u0002-\u000baC]3oI\u0016\u00148+\u001a:wS\u000e,gj\u001c3fg&sgm\u001c\u000b\b}\u0005\u001d\u00121FA\u0018\u0011\u0019\tI\u0003\u0005a\u0001}\u0005)A/\u001b;mK\"1\u0011Q\u0006\tA\u0002e\u000bqb]3sm&\u001cWMT8eK&sgm\u001c\u0005\u0006UA\u0001\r\u0001\f")
public class ServiceControlCli
implements Logging {
    private boolean verbose;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static void main(String[] stringArray) {
        ServiceControlCli$.MODULE$.main(stringArray);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private boolean verbose() {
        return this.verbose;
    }

    private void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public void doAction(String[] args) {
        this.initializeLoggerIfNecessary(true);
        ServiceControlCliArguments ctlArgs = this.parseArguments(args);
        if (ctlArgs.cliArgs() == null) {
            throw package$.MODULE$.exit(1);
        }
        this.verbose_$eq(ctlArgs.cliArgs().verbose());
        if (this.verbose()) {
            Logging.info$((Logging)this, (Function0 & Serializable & scala.Serializable)() -> ctlArgs.toString());
        }
        Enumeration.Value value = ctlArgs.cliArgs().action();
        Enumeration.Value value2 = ServiceControlAction$.MODULE$.CREATE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.create(ctlArgs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = ServiceControlAction$.MODULE$.LIST();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                this.list(ctlArgs, false);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = ServiceControlAction$.MODULE$.GET();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    this.list(ctlArgs, true);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value8 = ServiceControlAction$.MODULE$.DELETE();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        this.delete(ctlArgs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
    }

    public ServiceControlCliArguments parseArguments(String[] args) {
        return new ServiceControlCliArguments((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), ServiceControlCliArguments$.MODULE$.$lessinit$greater$default$2());
    }

    private void create(ServiceControlCliArguments args) {
        KyuubiConf kyuubiConf = args.conf();
        kyuubiConf.setIfMissing(HighAvailabilityConf$.MODULE$.HA_ZK_QUORUM(), (Object)args.cliArgs().zkQuorum());
        ZooKeeperClientProvider$.MODULE$.withZkClient(kyuubiConf, (Function1 & Serializable & scala.Serializable)zkClient -> {
            ServiceControlCli.$anonfun$create$1(this, kyuubiConf, args, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    private void list(ServiceControlCliArguments args, boolean filterHostPort) {
        ZooKeeperClientProvider$.MODULE$.withZkClient(args.conf(), (Function1 & Serializable & scala.Serializable)zkClient -> {
            ServiceControlCli.$anonfun$list$1(this, args, filterHostPort, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<ServiceNodeInfo> getServiceNodes(CuratorFramework zkClient, String znodeRoot, Option<Tuple2<String, Object>> hostPortOpt) {
        Seq seq;
        Some some;
        Tuple2 tuple2;
        Seq serviceNodes = ServiceDiscovery$.MODULE$.getServiceNodesInfo(zkClient, znodeRoot, ServiceDiscovery$.MODULE$.getServiceNodesInfo$default$3(), ServiceDiscovery$.MODULE$.getServiceNodesInfo$default$4());
        Option<Tuple2<String, Object>> option = hostPortOpt;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            seq = (Seq)serviceNodes.filter((Function1 & Serializable & scala.Serializable)sn -> BoxesRunTime.boxToBoolean((boolean)ServiceControlCli.$anonfun$getServiceNodes$1(host, port, sn)));
        } else {
            seq = serviceNodes;
        }
        return seq;
    }

    private void delete(ServiceControlCliArguments args) {
        ZooKeeperClientProvider$.MODULE$.withZkClient(args.conf(), (Function1 & Serializable & scala.Serializable)zkClient -> {
            ServiceControlCli.$anonfun$delete$1(this, args, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    private final void doCreate$1(CuratorFramework zc, Seq currentServerNodes$1, String fromNamespace$1, String toNamespace$1, KyuubiConf kyuubiConf$1, ServiceControlCliArguments args$1, ListBuffer exposedServiceNodes$1) {
        currentServerNodes$1.foreach((Function1 & Serializable & scala.Serializable)sn -> {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Exposing server instance:").append(sn.instance()).append(" with version:").append(sn.version()).append(" from ").append(fromNamespace$1).append(" to ").append(toNamespace$1).toString());
            String newNodePath = ServiceDiscovery$.MODULE$.createAndGetServiceNode(kyuubiConf$1, zc, args$1.cliArgs().namespace(), sn.instance(), sn.version(), true);
            return exposedServiceNodes$1.$plus$eq((Object)sn.copy(toNamespace$1, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newNodePath.split("/"))).last(), sn.copy$default$3(), sn.copy$default$4(), sn.copy$default$5(), sn.copy$default$6()));
        });
    }

    public static final /* synthetic */ void $anonfun$create$1(ServiceControlCli $this, KyuubiConf kyuubiConf$1, ServiceControlCliArguments args$1, CuratorFramework zkClient) {
        String fromNamespace = ZKPaths.makePath(null, (String)((String)kyuubiConf$1.get(HighAvailabilityConf$.MODULE$.HA_ZK_NAMESPACE())));
        String toNamespace = ServiceControlCli$.MODULE$.getZkNamespace(args$1);
        Seq currentServerNodes = ServiceDiscovery$.MODULE$.getServiceNodesInfo(zkClient, fromNamespace, ServiceDiscovery$.MODULE$.getServiceNodesInfo$default$3(), ServiceDiscovery$.MODULE$.getServiceNodesInfo$default$4());
        ListBuffer exposedServiceNodes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (currentServerNodes.nonEmpty()) {
            Object object = kyuubiConf$1.get(HighAvailabilityConf$.MODULE$.HA_ZK_QUORUM());
            String string = args$1.cliArgs().zkQuorum();
            if (!(object != null ? !object.equals(string) : string != null)) {
                $this.doCreate$1(zkClient, currentServerNodes, fromNamespace, toNamespace, kyuubiConf$1, args$1, exposedServiceNodes);
            } else {
                kyuubiConf$1.set(HighAvailabilityConf$.MODULE$.HA_ZK_QUORUM(), (Object)args$1.cliArgs().zkQuorum());
                ZooKeeperClientProvider$.MODULE$.withZkClient(kyuubiConf$1, (Function1 & Serializable & scala.Serializable)zc -> {
                    $this.doCreate$1(zc, currentServerNodes, fromNamespace, toNamespace, kyuubiConf$1, args$1, exposedServiceNodes);
                    return BoxedUnit.UNIT;
                });
            }
        }
        String title = "Created zookeeper service nodes";
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> ServiceControlCli$.MODULE$.renderServiceNodesInfo(title, (Seq<ServiceNodeInfo>)exposedServiceNodes, $this.verbose()));
    }

    public static final /* synthetic */ void $anonfun$list$1(ServiceControlCli $this, ServiceControlCliArguments args$2, boolean filterHostPort$1, CuratorFramework zkClient) {
        String znodeRoot = ServiceControlCli$.MODULE$.getZkNamespace(args$2);
        None$ hostPortOpt = filterHostPort$1 ? new Some((Object)new Tuple2((Object)args$2.cliArgs().host(), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args$2.cliArgs().port())).toInt()))) : None$.MODULE$;
        Seq<ServiceNodeInfo> nodes = $this.getServiceNodes(zkClient, znodeRoot, (Option<Tuple2<String, Object>>)hostPortOpt);
        String title = "Zookeeper service nodes";
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> ServiceControlCli$.MODULE$.renderServiceNodesInfo(title, nodes, $this.verbose()));
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNodes$1(String host$1, int port$1, ServiceNodeInfo sn) {
        String string = sn.host();
        String string2 = host$1;
        return !(string != null ? !string.equals(string2) : string2 != null) && sn.port() == port$1;
    }

    public static final /* synthetic */ void $anonfun$delete$1(ServiceControlCli $this, ServiceControlCliArguments args$3, CuratorFramework zkClient) {
        String znodeRoot = ServiceControlCli$.MODULE$.getZkNamespace(args$3);
        Some hostPortOpt = new Some((Object)new Tuple2((Object)args$3.cliArgs().host(), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args$3.cliArgs().port())).toInt())));
        Seq<ServiceNodeInfo> nodesToDelete = $this.getServiceNodes(zkClient, znodeRoot, (Option<Tuple2<String, Object>>)hostPortOpt);
        ListBuffer deletedNodes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        nodesToDelete.foreach((Function1 & Serializable & scala.Serializable)node -> {
            ListBuffer listBuffer;
            String nodePath = new StringBuilder(1).append(znodeRoot).append("/").append(node.nodeName()).toString();
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleting zookeeper service node:").append(nodePath).toString());
            try {
                zkClient.delete().forPath(nodePath);
                listBuffer = deletedNodes.$plus$eq(node);
            }
            catch (Exception e) {
                $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to delete zookeeper service node:").append(nodePath).toString(), e);
                listBuffer = BoxedUnit.UNIT;
            }
            return listBuffer;
        });
        String title = "Deleted zookeeper service nodes";
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> ServiceControlCli$.MODULE$.renderServiceNodesInfo(title, (Seq<ServiceNodeInfo>)deletedNodes, $this.verbose()));
    }

    public ServiceControlCli() {
        Logging.$init$((Logging)this);
        this.verbose = false;
    }
}

