/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.common.JavaUtils;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.metastore.hooks.JDOConnectionURLHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreInit {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreInit.class);

    static boolean updateConnectionURL(HiveConf originalConf, Configuration activeConf, String badUrl, MetaStoreInitData updateData) throws MetaException {
        String connectUrl = null;
        String currentUrl = MetaStoreInit.getConnectionURL(activeConf);
        try {
            MetaStoreInit.initConnectionUrlHook(originalConf, updateData);
            if (updateData.urlHook != null) {
                if (badUrl != null) {
                    updateData.urlHook.notifyBadConnectionUrl(badUrl);
                }
                connectUrl = updateData.urlHook.getJdoConnectionUrl(originalConf);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while getting connection URL from the hook: " + e);
        }
        if (connectUrl != null && !connectUrl.equals(currentUrl)) {
            LOG.error(String.format("Overriding %s with %s", HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl));
            activeConf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl);
            return true;
        }
        return false;
    }

    static String getConnectionURL(Configuration conf) {
        return conf.get(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), "");
    }

    private static synchronized void initConnectionUrlHook(HiveConf hiveConf, MetaStoreInitData updateData) throws ClassNotFoundException {
        boolean urlHookChanged;
        String className = hiveConf.get(HiveConf.ConfVars.METASTORECONNECTURLHOOK.toString(), "").trim();
        if (className.equals("")) {
            updateData.urlHookClassName = "";
            updateData.urlHook = null;
            return;
        }
        boolean bl = urlHookChanged = !updateData.urlHookClassName.equals(className);
        if (updateData.urlHook == null || urlHookChanged) {
            updateData.urlHookClassName = className.trim();
            Class<?> urlHookClass = Class.forName(updateData.urlHookClassName, true, JavaUtils.getClassLoader());
            updateData.urlHook = (JDOConnectionURLHook)ReflectionUtils.newInstance(urlHookClass, null);
        }
    }

    static class MetaStoreInitData {
        JDOConnectionURLHook urlHook = null;
        String urlHookClassName = "";

        MetaStoreInitData() {
        }
    }
}

