/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2;

import java.util.ArrayList;
import java.util.List;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public abstract class BaseStructObjectInspector
extends StructObjectInspector {
    protected final List<MyField> fields = new ArrayList<MyField>();

    protected BaseStructObjectInspector() {
    }

    public BaseStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors) {
        this.init(structFieldNames, structFieldObjectInspectors, null);
    }

    public BaseStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments) {
        this.init(structFieldNames, structFieldObjectInspectors, structFieldComments);
    }

    protected void init(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments) {
        assert (structFieldNames.size() == structFieldObjectInspectors.size());
        assert (structFieldComments == null || structFieldNames.size() == structFieldComments.size());
        for (int i = 0; i < structFieldNames.size(); ++i) {
            this.fields.add(this.createField(i, structFieldNames.get(i), structFieldObjectInspectors.get(i), structFieldComments == null ? null : structFieldComments.get(i)));
        }
    }

    protected void init(List<StructField> structFields) {
        for (int i = 0; i < structFields.size(); ++i) {
            this.fields.add(new MyField(i, structFields.get(i)));
        }
    }

    protected MyField createField(int index, String fieldName, ObjectInspector fieldOI, String comment) {
        return new MyField(index, fieldName, fieldOI, comment);
    }

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName(this);
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        return ObjectInspectorUtils.getStandardStructFieldRef(fieldName, this.fields);
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    protected static class MyField
    implements StructField {
        protected final int fieldID;
        protected final String fieldName;
        protected final String fieldComment;
        protected final ObjectInspector fieldObjectInspector;

        public MyField(int fieldID, String fieldName, ObjectInspector fieldObjectInspector, String fieldComment) {
            this.fieldID = fieldID;
            this.fieldName = fieldName.toLowerCase();
            this.fieldObjectInspector = fieldObjectInspector;
            this.fieldComment = fieldComment;
        }

        public MyField(int fieldID, StructField field) {
            this.fieldID = fieldID;
            this.fieldName = field.getFieldName().toLowerCase();
            this.fieldObjectInspector = field.getFieldObjectInspector();
            this.fieldComment = field.getFieldComment();
        }

        @Override
        public int getFieldID() {
            return this.fieldID;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.fieldObjectInspector;
        }

        @Override
        public String getFieldComment() {
            return this.fieldComment;
        }

        public String toString() {
            return this.fieldID + ":" + this.fieldName;
        }
    }
}

