/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.objectinspector.StructField;

public class ReflectionStructObjectInspector
extends SettableStructObjectInspector {
    Class<?> objectClass;
    List<MyField> fields;
    volatile boolean inited = false;
    volatile Type type;

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public String getTypeName() {
        StringBuilder sb = new StringBuilder("struct<");
        boolean first = true;
        for (StructField structField : this.getAllStructFieldRefs()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(structField.getFieldName()).append(":").append(structField.getFieldObjectInspector().getTypeName());
        }
        sb.append(">");
        return sb.toString();
    }

    ReflectionStructObjectInspector() {
    }

    protected boolean isFullyInited(Set<Type> checkedTypes) {
        if (this.type != null && ObjectInspectorFactory.objectInspectorCache.get(this.type) != this) {
            throw new RuntimeException("Cached object inspector is gone while waiting for it to initialize");
        }
        if (!this.inited) {
            return false;
        }
        checkedTypes.add(this.type);
        for (StructField structField : this.getAllStructFieldRefs()) {
            ObjectInspector oi = structField.getFieldObjectInspector();
            if (!(oi instanceof ReflectionStructObjectInspector)) continue;
            ReflectionStructObjectInspector soi = (ReflectionStructObjectInspector)oi;
            if (checkedTypes.contains(soi.type) || soi.isFullyInited(checkedTypes)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(Type type, Class<?> objectClass, ObjectInspectorFactory.ObjectInspectorOptions options) {
        this.type = type;
        this.verifyObjectClassType(objectClass);
        this.objectClass = objectClass;
        List<? extends ObjectInspector> structFieldObjectInspectors = this.extractFieldObjectInspectors(objectClass, options);
        Field[] reflectionFields = ObjectInspectorUtils.getDeclaredNonStaticFields(objectClass);
        ReflectionStructObjectInspector reflectionStructObjectInspector = this;
        synchronized (reflectionStructObjectInspector) {
            this.fields = new ArrayList<MyField>(structFieldObjectInspectors.size());
            int used = 0;
            for (int i = 0; i < reflectionFields.length; ++i) {
                if (this.shouldIgnoreField(reflectionFields[i].getName())) continue;
                reflectionFields[i].setAccessible(true);
                this.fields.add(new MyField(i, reflectionFields[i], structFieldObjectInspectors.get(used++)));
            }
            assert (this.fields.size() == structFieldObjectInspectors.size());
            this.inited = true;
            this.notifyAll();
        }
    }

    public boolean shouldIgnoreField(String name) {
        return false;
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        return ObjectInspectorUtils.getStandardStructFieldRef(fieldName, this.fields);
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        if (!(fieldRef instanceof MyField)) {
            throw new RuntimeException("fieldRef has to be of MyField");
        }
        MyField f = (MyField)fieldRef;
        try {
            Object r = f.field.get(data);
            return r;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot get field " + f.field + " from " + data.getClass() + " " + data, e);
        }
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        try {
            ArrayList<Object> result = new ArrayList<Object>(this.fields.size());
            for (int i = 0; i < this.fields.size(); ++i) {
                result.add(this.fields.get((int)i).field.get(data));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object create() {
        return ReflectionUtils.newInstance(this.objectClass, null);
    }

    @Override
    public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
        MyField myField = (MyField)field;
        try {
            myField.field.set(struct, fieldValue);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot set field " + myField.field + " of " + struct.getClass() + " " + struct, e);
        }
        return struct;
    }

    protected List<? extends ObjectInspector> extractFieldObjectInspectors(Class<?> clazz, ObjectInspectorFactory.ObjectInspectorOptions options) {
        Field[] fields = ObjectInspectorUtils.getDeclaredNonStaticFields(clazz);
        ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            if (this.shouldIgnoreField(fields[i].getName())) continue;
            structFieldObjectInspectors.add(ObjectInspectorFactory.getReflectionObjectInspector(fields[i].getGenericType(), options, false));
        }
        return structFieldObjectInspectors;
    }

    protected void verifyObjectClassType(Class<?> objectClass) {
        assert (!List.class.isAssignableFrom(objectClass));
        assert (!Map.class.isAssignableFrom(objectClass));
    }

    public static class MyField
    implements StructField {
        protected int fieldID;
        protected Field field;
        protected ObjectInspector fieldObjectInspector;

        protected MyField() {
        }

        public MyField(int fieldID, Field field, ObjectInspector fieldObjectInspector) {
            this.fieldID = fieldID;
            this.field = field;
            this.fieldObjectInspector = fieldObjectInspector;
        }

        @Override
        public String getFieldName() {
            return this.field.getName().toLowerCase();
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.fieldObjectInspector;
        }

        @Override
        public int getFieldID() {
            return this.fieldID;
        }

        @Override
        public String getFieldComment() {
            return null;
        }

        public String toString() {
            return this.field.toString();
        }
    }
}

