/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service.auth;

import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shade.org.apache.thrift.TException;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocol;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TSaslClientTransport;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TSaslServerTransport;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TSocket;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSetIpAddressProcessor<I extends TCLIService.Iface>
extends TCLIService.Processor<TCLIService.Iface> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TSetIpAddressProcessor.class.getName());
    private static final ThreadLocal<String> THREAD_LOCAL_IP_ADDRESS = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<String> THREAD_LOCAL_USER_NAME = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };

    public TSetIpAddressProcessor(TCLIService.Iface iface) {
        super(iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(TProtocol in, TProtocol out) throws TException {
        this.setIpAddress(in);
        this.setUserName(in);
        try {
            boolean bl = super.process(in, out);
            return bl;
        }
        finally {
            THREAD_LOCAL_USER_NAME.remove();
            THREAD_LOCAL_IP_ADDRESS.remove();
        }
    }

    private void setUserName(TProtocol in) {
        TTransport transport = in.getTransport();
        if (transport instanceof TSaslServerTransport) {
            String userName = ((TSaslServerTransport)transport).getSaslServer().getAuthorizationID();
            THREAD_LOCAL_USER_NAME.set(userName);
        }
    }

    protected void setIpAddress(TProtocol in) {
        TTransport transport = in.getTransport();
        TSocket tSocket = this.getUnderlyingSocketFromTransport(transport);
        if (tSocket == null) {
            LOGGER.warn("Unknown Transport, cannot determine ipAddress");
        } else {
            THREAD_LOCAL_IP_ADDRESS.set(tSocket.getSocket().getInetAddress().getHostAddress());
        }
    }

    private TSocket getUnderlyingSocketFromTransport(TTransport transport) {
        while (transport != null) {
            if (transport instanceof TSaslServerTransport) {
                transport = ((TSaslServerTransport)transport).getUnderlyingTransport();
            }
            if (transport instanceof TSaslClientTransport) {
                transport = ((TSaslClientTransport)transport).getUnderlyingTransport();
            }
            if (!(transport instanceof TSocket)) continue;
            return (TSocket)transport;
        }
        return null;
    }

    public static String getUserIpAddress() {
        return THREAD_LOCAL_IP_ADDRESS.get();
    }

    public static String getUserName() {
        return THREAD_LOCAL_USER_NAME.get();
    }
}

